/*
 * Decompiled with CFR 0.152.
 */
package adams.data.mapobject;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.mapobject.HitIndicator;
import adams.data.mapobject.SimpleMapMarkerCircle;
import java.awt.Color;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

@MixedCopyright(copyright="2008 OpenStreetMap", author="Jan Peter Stotz", license=License.GPL2, url="http://svn.openstreetmap.org/applications/viewer/jmapviewer/releases/1.02/JMapViewer-1.02-Source.zip", note="Original class: org.openstreetmap.gui.jmapviewer.MapMarkerDot")
public class SimpleMapMarkerDot
extends SimpleMapMarkerCircle
implements HitIndicator {
    public static final int DOT_RADIUS = 5;

    public SimpleMapMarkerDot(Coordinate coord) {
        this(null, null, coord);
    }

    public SimpleMapMarkerDot(String name, Coordinate coord) {
        this(null, name, coord);
    }

    public SimpleMapMarkerDot(Layer layer, Coordinate coord) {
        this(layer, null, coord);
    }

    public SimpleMapMarkerDot(Layer layer, String name, Coordinate coord) {
        this(layer, name, coord, SimpleMapMarkerDot.getDefaultStyle());
    }

    public SimpleMapMarkerDot(Color color, double lat, double lon) {
        this(null, null, lat, lon);
        this.setColor(color);
    }

    public SimpleMapMarkerDot(double lat, double lon) {
        this(null, null, lat, lon);
    }

    public SimpleMapMarkerDot(Layer layer, double lat, double lon) {
        this(layer, null, lat, lon);
    }

    public SimpleMapMarkerDot(Layer layer, String name, double lat, double lon) {
        this(layer, name, new Coordinate(lat, lon), SimpleMapMarkerDot.getDefaultStyle());
    }

    public SimpleMapMarkerDot(Layer layer, String name, Coordinate coord, Style style) {
        super(layer, name, coord, 5.0, MapMarker.STYLE.FIXED, style);
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLACK, Color.YELLOW, null, SimpleMapMarkerDot.getDefaultFont());
    }

    @Override
    public String toString() {
        return "MarkerDot: name=" + this.getName() + ", coord=" + this.getCoordinate() + ", meta=" + this.getMetaData();
    }
}

