/*
 * Decompiled with CFR 0.152.
 */
package adams.data.mapobject;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.mapobject.MetaDataSupporter;
import adams.data.mapobject.TimestampSupporter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.swing.UIManager;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

@MixedCopyright(copyright="OpenStreetMap", license=License.GPL2, url="http://svn.openstreetmap.org/applications/viewer/jmapviewer/releases/1.02/JMapViewer-1.02-Source.zip", note="Original class: org.openstreetmap.gui.jmapviewer.MapObjectImpl")
public abstract class AbstractMapObject
implements MapObject,
MetaDataSupporter,
TimestampSupporter {
    protected Layer layer;
    protected String name;
    protected Style style;
    protected Boolean visible;
    protected Date timestamp;
    protected HashMap<String, Object> metaData;

    public AbstractMapObject(String name) {
        this(null, name, null);
    }

    public AbstractMapObject(Layer layer) {
        this(layer, null, null);
    }

    public AbstractMapObject(Layer layer, String name, Style style) {
        this.layer = layer;
        this.name = name;
        this.style = style;
        this.metaData = new HashMap();
        this.timestamp = new Date();
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public Style getStyle() {
        return this.style;
    }

    public Style getStyleAssigned() {
        return this.style == null ? (this.layer == null ? null : this.layer.getStyle()) : this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Color getColor() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getColor();
    }

    public void setColor(Color color) {
        if (this.style == null && color != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setColor(color);
        }
    }

    public Color getBackColor() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getBackColor();
    }

    public void setBackColor(Color backColor) {
        if (this.style == null && backColor != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setBackColor(backColor);
        }
    }

    public Stroke getStroke() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getStroke();
    }

    public void setStroke(Stroke stroke) {
        if (this.style == null && stroke != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setStroke(stroke);
        }
    }

    public Font getFont() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getFont();
    }

    public void setFont(Font font) {
        if (this.style == null && font != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setFont(font);
        }
    }

    private boolean isVisibleLayer() {
        return this.layer == null || this.layer.isVisible() == null ? true : this.layer.isVisible();
    }

    public boolean isVisible() {
        return this.visible == null ? this.isVisibleLayer() : this.visible.booleanValue();
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String txt) {
        this.name = txt;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date value) {
        this.timestamp = value;
    }

    @Override
    public Object addMetaData(String key, Object value) {
        return this.metaData.put(key, value);
    }

    @Override
    public Object removeMetaData(String key) {
        return this.metaData.remove(key);
    }

    @Override
    public Object getMetaData(String key) {
        return this.metaData.get(key);
    }

    @Override
    public HashMap<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public Set<String> metaDataKeys() {
        return this.metaData.keySet();
    }

    public static Font getDefaultFont() {
        Font f = UIManager.getDefaults().getFont("TextField.font");
        return new Font(f.getName(), 1, f.getSize());
    }

    public void paintText(Graphics g, Point position) {
        if (this.name != null && g != null && position != null) {
            if (this.getFont() == null) {
                Font f = AbstractMapObject.getDefaultFont();
                this.setFont(new Font(f.getName(), 1, f.getSize()));
            }
            g.setColor(Color.DARK_GRAY);
            g.setFont(this.getFont());
            g.drawString(this.name, position.x + 5 + 2, position.y + 5);
        }
    }
}

