/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.AdditionalInformationHandler;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.gps.GPSDecimalDegrees;
import adams.data.mapobject.HitIndicator;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.openstreetmapviewer.AbstractMapClickListener;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectHitListener;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectPruner;
import adams.flow.sink.openstreetmapviewer.AbstractMapOverlay;
import adams.flow.sink.openstreetmapviewer.AbstractTileLoaderProvider;
import adams.flow.sink.openstreetmapviewer.AbstractTileSourceProvider;
import adams.flow.sink.openstreetmapviewer.NullMapClickListener;
import adams.flow.sink.openstreetmapviewer.NullMapObjectHitListener;
import adams.flow.sink.openstreetmapviewer.NullMapOverlay;
import adams.flow.sink.openstreetmapviewer.NullPruner;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapLoader;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapSource;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.MouseUtils;
import adams.gui.core.dotnotationtree.DotNotationNode;
import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.event.MapClickEvent;
import adams.gui.event.MapObjectHitEvent;
import adams.gui.visualization.osm.OpenStreetMapViewerTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class OpenStreetMapViewer
extends AbstractGraphicalDisplay
implements AdditionalInformationHandler {
    private static final long serialVersionUID = -6066131046841201616L;
    protected OpenStreetMapViewerTree m_Viewer;
    protected HashMap<String, Layer> m_LayerLookup;
    protected AbstractTileSourceProvider m_TileSource;
    protected AbstractTileLoaderProvider m_TileLoader;
    protected AbstractMapObjectHitListener m_HitListener;
    protected AbstractMapClickListener m_ClickListener;
    protected AbstractMapObjectPruner m_MapObjectPruner;
    protected AbstractMapOverlay m_MapOverlay;
    protected GPSDecimalDegrees m_InitialCoordinates;
    protected int m_InitialZoom;
    protected boolean m_ZoomControls;
    protected boolean m_TileGrid;
    protected boolean m_LayerTree;
    protected int m_DividerLocation;
    protected String m_LayerTreeRoot;
    protected BaseString[] m_Layers;
    protected JPanel m_MapOverlayPlaceholderPanel;

    public String globalInfo() {
        return "Displays data layers (markers, rectangles and polygons) on top of a map provided by OpenStreetMap.";
    }

    public String getAdditionalInformation() {
        return super.getAdditionalInformation() + "\n\nUses the JMapViewer component:\nhttps://wiki.openstreetmap.org/wiki/JMapViewer";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tile-source", "tileSource", (Object)new OpenStreetMapSource());
        this.m_OptionManager.add("tile-loader", "tileLoader", (Object)new OpenStreetMapLoader());
        this.m_OptionManager.add("hit-listener", "hitListener", (Object)new NullMapObjectHitListener());
        this.m_OptionManager.add("click-listener", "clickListener", (Object)new NullMapClickListener());
        this.m_OptionManager.add("mapobject-pruner", "mapObjectPruner", (Object)new NullPruner());
        this.m_OptionManager.add("map-overlay", "mapOverlay", (Object)new NullMapOverlay());
        this.m_OptionManager.add("initial-coordinates", "initialCoordinates", (Object)new GPSDecimalDegrees());
        this.m_OptionManager.add("initial-zoom", "initialZoom", (Object)0, (Number)0, null);
        this.m_OptionManager.add("zoom-controls", "zoomControls", (Object)true);
        this.m_OptionManager.add("tile-grid", "tileGrid", (Object)false);
        this.m_OptionManager.add("divider-location", "dividerLocation", (Object)150, (Number)0, null);
        this.m_OptionManager.add("layer-tree", "layerTree", (Object)false);
        this.m_OptionManager.add("layer-tree-root", "layerTreeRoot", (Object)"Layers");
        this.m_OptionManager.add("layer", "layers", (Object)new BaseString[]{new BaseString("Default")});
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"tileSource", (Object)((Object)this.m_TileSource), (String)"source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"tileLoader", (Object)((Object)this.m_TileLoader), (String)", loader: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"hitListener", (Object)this.m_HitListener, (String)", hits: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"clickListener", (Object)this.m_ClickListener, (String)", clicks: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"mapObjectPruner", (Object)((Object)this.m_MapObjectPruner), (String)", pruner: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"mapOverlay", (Object)((Object)this.m_MapObjectPruner), (String)", overlay: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"layers", (Object)(this.m_Layers.length == 0 ? "none" : Utils.arrayToString((Object)this.m_Layers)), (String)", layers: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"zoomControls", (boolean)this.m_ZoomControls, (String)"zoom ctrls"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"tileGrid", (boolean)this.m_TileGrid, (String)"grid"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"layerTree", (boolean)this.m_LayerTree, (String)"layer tree"));
        result = result + ", " + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setTileSource(AbstractTileSourceProvider value) {
        this.m_TileSource = value;
        this.reset();
    }

    public AbstractTileSourceProvider getTileSource() {
        return this.m_TileSource;
    }

    public String tileSourceTipText() {
        return "The provider for generating the tile source.";
    }

    public void setTileLoader(AbstractTileLoaderProvider value) {
        this.m_TileLoader = value;
        this.reset();
    }

    public AbstractTileLoaderProvider getTileLoader() {
        return this.m_TileLoader;
    }

    public String tileLoaderTipText() {
        return "The provider for generating the tile loader.";
    }

    public void setHitListener(AbstractMapObjectHitListener value) {
        this.m_HitListener = value;
        this.reset();
    }

    public AbstractMapObjectHitListener getHitListener() {
        return this.m_HitListener;
    }

    public String hitListenerTipText() {
        return "The listener for hits when the user left-clicks on map objects.";
    }

    public void setClickListener(AbstractMapClickListener value) {
        this.m_ClickListener = value;
        this.reset();
    }

    public AbstractMapClickListener getClickListener() {
        return this.m_ClickListener;
    }

    public String clickListenerTipText() {
        return "The listener for clicks on the map.";
    }

    public void setMapObjectPruner(AbstractMapObjectPruner value) {
        this.m_MapObjectPruner = value;
        this.reset();
    }

    public AbstractMapObjectPruner getMapObjectPruner() {
        return this.m_MapObjectPruner;
    }

    public String mapObjectPrunerTipText() {
        return "The scheme for pruning the map objects.";
    }

    public void setMapOverlay(AbstractMapOverlay value) {
        this.m_MapOverlay = value;
        this.reset();
    }

    public AbstractMapOverlay getMapOverlay() {
        return this.m_MapOverlay;
    }

    public String mapOverlayTipText() {
        return "The overlay for the map.";
    }

    public void setInitialCoordinates(GPSDecimalDegrees value) {
        this.m_InitialCoordinates = value;
        this.reset();
    }

    public GPSDecimalDegrees getInitialCoordinates() {
        return this.m_InitialCoordinates;
    }

    public String initialCoordinatesTipText() {
        return "The initial coordinates to use.";
    }

    public void setInitialZoom(int value) {
        if (value >= 0) {
            this.m_InitialZoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Initial zoom level must be at least 0, provided: " + value);
        }
    }

    public int getInitialZoom() {
        return this.m_InitialZoom;
    }

    public String initialZoomTipText() {
        return "The initial zoom to use.";
    }

    public void setZoomControls(boolean value) {
        this.m_ZoomControls = value;
        this.reset();
    }

    public boolean getZoomControls() {
        return this.m_ZoomControls;
    }

    public String zoomControlsTipText() {
        return "If enabled the zoom controls will get displayed.";
    }

    public void setTileGrid(boolean value) {
        this.m_TileGrid = value;
        this.reset();
    }

    public boolean getTileGrid() {
        return this.m_TileGrid;
    }

    public String tileGridTipText() {
        return "If enabled, the tile grid gets displayed.";
    }

    public void setDividerLocation(int value) {
        this.m_DividerLocation = value;
        this.reset();
    }

    public int getDividerLocation() {
        return this.m_DividerLocation;
    }

    public String dividerLocationTipText() {
        return "The location in pixels for the divider between layer tree and map.";
    }

    public void setLayerTree(boolean value) {
        this.m_LayerTree = value;
        this.reset();
    }

    public boolean getLayerTree() {
        return this.m_LayerTree;
    }

    public String layerTreeTipText() {
        return "If enabled, the layer tree is displayed.";
    }

    public void setLayerTreeRoot(String value) {
        this.m_LayerTreeRoot = value;
        this.reset();
    }

    public String getLayerTreeRoot() {
        return this.m_LayerTreeRoot;
    }

    public String layerTreeRootTipText() {
        return "The label for the root of the layer tree.";
    }

    public void setLayers(BaseString[] value) {
        this.m_Layers = value;
        this.reset();
    }

    public BaseString[] getLayers() {
        return this.m_Layers;
    }

    public String layersTipText() {
        return "The layer names; use '.' to separate levels, eg the three layers 'A A.B A.C' will create layers B and C below A.";
    }

    public JMapViewerTree getViewer() {
        return this.m_Viewer;
    }

    public Class[] accepts() {
        return new Class[]{MapMarker.class, MapMarker[].class, MapPolygon.class, MapPolygon[].class, MapRectangle.class, MapRectangle[].class};
    }

    protected boolean updateLayer(MapObject object) {
        String name = object.getLayer().getName();
        if (this.m_LayerLookup.containsKey(name)) {
            object.setLayer(this.m_LayerLookup.get(name));
            return true;
        }
        return false;
    }

    protected void display(Token token) {
        if (token.getPayload() instanceof MapMarker) {
            MapMarker marker = (MapMarker)token.getPayload();
            if (this.updateLayer((MapObject)marker)) {
                this.m_Viewer.getViewer().addMapMarker(marker);
            }
        } else if (token.getPayload() instanceof MapMarker[]) {
            MapMarker[] markers;
            for (MapMarker marker : markers = (MapMarker[])token.getPayload()) {
                if (!this.updateLayer((MapObject)marker)) continue;
                this.m_Viewer.getViewer().addMapMarker(marker);
            }
        } else if (token.getPayload() instanceof MapPolygon) {
            MapPolygon polygon = (MapPolygon)token.getPayload();
            if (this.updateLayer((MapObject)polygon)) {
                this.m_Viewer.getViewer().addMapPolygon(polygon);
            }
        } else if (token.getPayload() instanceof MapPolygon[]) {
            MapPolygon[] polygons;
            for (MapPolygon polygon : polygons = (MapPolygon[])token.getPayload()) {
                if (!this.updateLayer((MapObject)polygon)) continue;
                this.m_Viewer.getViewer().addMapPolygon(polygon);
            }
        } else if (token.getPayload() instanceof MapRectangle) {
            MapRectangle rectangle = (MapRectangle)token.getPayload();
            if (this.updateLayer((MapObject)rectangle)) {
                this.m_Viewer.getViewer().addMapRectangle(rectangle);
            }
        } else if (token.getPayload() instanceof MapRectangle[]) {
            MapRectangle[] rectangles;
            for (MapRectangle rectangle : rectangles = (MapRectangle[])token.getPayload()) {
                if (!this.updateLayer((MapObject)rectangle)) continue;
                this.m_Viewer.getViewer().addMapRectangle(rectangle);
            }
        }
        if (!(this.m_MapObjectPruner instanceof NullPruner)) {
            this.m_MapObjectPruner.prune(this.m_Viewer);
        }
    }

    public void clearPanel() {
        if (this.m_Viewer != null) {
            this.m_Viewer.getViewer().removeAllMapMarkers();
            this.m_Viewer.getViewer().removeAllMapPolygons();
            this.m_Viewer.getViewer().removeAllMapRectangles();
            this.m_Viewer.getTree().setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(new CheckBoxNodeData(this.m_LayerTreeRoot))));
        }
    }

    protected void addLayers(DotNotationNode parent, LayerGroup group) {
        if (parent.getChildCount() == 0) {
            Layer layer;
            if (group == null) {
                layer = this.m_Viewer.getTree().addLayer(parent.getLabel());
            } else {
                layer = group.addLayer(parent.getLabel());
                this.m_Viewer.getTree().addLayer((AbstractLayer)layer);
            }
            this.m_LayerLookup.put(parent.getItem(), layer);
        } else {
            LayerGroup groupNested = group == null ? new LayerGroup(parent.getLabel()) : new LayerGroup(group, parent.getLabel());
            this.m_Viewer.getTree().addLayer((AbstractLayer)groupNested);
            for (BaseTreeNode node : parent.getChildren()) {
                this.addLayers((DotNotationNode)node, groupNested);
            }
        }
    }

    protected void createLayerTree() {
        DotNotationTree tree = new DotNotationTree();
        tree.setCompress(false);
        tree.setItems(this.m_Layers);
        this.m_LayerLookup = new HashMap();
        DotNotationNode root = (DotNotationNode)tree.getModel().getRoot();
        if (root != null) {
            for (BaseTreeNode node : root.getChildren()) {
                this.addLayers((DotNotationNode)node, null);
            }
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel();
        result.setLayout((LayoutManager)new BorderLayout());
        this.m_Viewer = new OpenStreetMapViewerTree(this.m_LayerTreeRoot);
        this.m_Viewer.setTreeVisible(this.m_LayerTree);
        this.m_Viewer.setDividerLocation(this.m_DividerLocation);
        this.createLayerTree();
        this.m_Viewer.getViewer().setZoomContolsVisible(this.m_ZoomControls);
        this.m_Viewer.getViewer().setTileGridVisible(this.m_TileGrid);
        try {
            this.m_Viewer.getViewer().setTileSource(this.m_TileSource.generate());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to generate tile source: " + OptionUtils.getCommandLine((Object)((Object)this.m_TileSource)), (Throwable)e);
            this.m_Viewer.getViewer().setTileSource((TileSource)new OsmTileSource.Mapnik());
        }
        try {
            this.m_Viewer.getViewer().setTileLoader(this.m_TileLoader.generate((TileLoaderListener)this.m_Viewer.getViewer()));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to generate tile loader: " + OptionUtils.getCommandLine((Object)((Object)this.m_TileLoader)), (Throwable)e);
            this.m_Viewer.getViewer().setTileLoader((TileLoader)new OsmTileLoader((TileLoaderListener)this.m_Viewer.getViewer()));
        }
        this.m_Viewer.getViewer().setDisplayPositionByLatLon(this.m_InitialCoordinates.getLatitude().toDecimal(), this.m_InitialCoordinates.getLongitude().toDecimal(), this.m_InitialZoom);
        this.m_Viewer.getViewer().setZoom(this.m_InitialZoom);
        if (!(this.m_HitListener instanceof NullMapObjectHitListener)) {
            this.m_Viewer.getViewer().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isLeftClick((MouseEvent)e)) {
                        ArrayList<MapObject> hits = new ArrayList<MapObject>();
                        Coordinate coord = OpenStreetMapViewer.this.m_Viewer.getViewer().getPosition(e.getPoint());
                        HashSet<AbstractLayer> visible = new HashSet<AbstractLayer>(OpenStreetMapViewer.this.m_Viewer.getVisibleLayers());
                        for (MapMarker obj : OpenStreetMapViewer.this.m_Viewer.getViewer().getMapMarkerList()) {
                            if (!visible.contains(obj.getLayer()) || !(obj instanceof HitIndicator) || !((HitIndicator)obj).isHit(OpenStreetMapViewer.this.m_Viewer.getViewer(), coord)) continue;
                            hits.add((MapObject)obj);
                        }
                        for (MapMarker obj : OpenStreetMapViewer.this.m_Viewer.getViewer().getMapRectangleList()) {
                            if (!visible.contains(obj.getLayer()) || !(obj instanceof HitIndicator) || !((HitIndicator)obj).isHit(OpenStreetMapViewer.this.m_Viewer.getViewer(), coord)) continue;
                            hits.add((MapObject)obj);
                        }
                        for (MapMarker obj : OpenStreetMapViewer.this.m_Viewer.getViewer().getMapPolygonList()) {
                            if (!visible.contains(obj.getLayer()) || !(obj instanceof HitIndicator) || !((HitIndicator)obj).isHit(OpenStreetMapViewer.this.m_Viewer.getViewer(), coord)) continue;
                            hits.add((MapObject)obj);
                        }
                        if (hits.size() > 0) {
                            OpenStreetMapViewer.this.m_HitListener.mapObjectsHit(new MapObjectHitEvent(OpenStreetMapViewer.this.m_Viewer.getViewer(), hits));
                            e.consume();
                        }
                    }
                    if (!e.isConsumed()) {
                        super.mouseClicked(e);
                    }
                }
            });
        }
        if (!(this.m_ClickListener instanceof NullMapClickListener)) {
            if (this.m_ClickListener.requiresDatabaseConnection()) {
                this.m_ClickListener.updateDatabaseConnection((Actor)this);
            }
            this.m_Viewer.getViewer().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isLeftClick((MouseEvent)e) && !e.isConsumed()) {
                        OpenStreetMapViewer.this.m_ClickListener.mapClicked(new MapClickEvent(OpenStreetMapViewer.this.m_Viewer.getViewer(), e));
                    }
                    if (!e.isConsumed()) {
                        super.mouseClicked(e);
                    }
                }
            });
        }
        result.add((Component)((Object)this.m_Viewer), (Object)"Center");
        this.m_MapOverlayPlaceholderPanel = new JPanel(){
            private static final long serialVersionUID = 8792227302889651948L;

            @Override
            public void validate() {
                super.validate();
                Rectangle rect = this.getParent().getBounds();
                this.setBounds(0, 0, rect.width, rect.height);
            }

            @Override
            protected void paintComponent(Graphics g) {
                OpenStreetMapViewer.this.m_MapOverlay.paintOverlay(OpenStreetMapViewer.this, g);
            }
        };
        this.m_MapOverlayPlaceholderPanel.setOpaque(false);
        this.m_Viewer.getViewer().add((Component)this.m_MapOverlayPlaceholderPanel);
        return result;
    }
}

