/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.io.PlaceholderFile;
import adams.flow.sink.OpenStreetMapViewer;
import adams.flow.sink.openstreetmapviewer.AbstractPositionableMapOverlay;
import java.awt.Graphics;
import javax.swing.ImageIcon;

public class ImageMapOverlay
extends AbstractPositionableMapOverlay {
    private static final long serialVersionUID = 41349852232785589L;
    protected PlaceholderFile m_ImageFile;
    protected transient ImageIcon m_Image;
    protected double m_Scale;

    public String globalInfo() {
        return "Overlays the map with an icon obtained from a file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-file", "imageFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("scale", "scale", (Object)1.0, (Number)0.0, null);
    }

    public void setImageFile(PlaceholderFile value) {
        this.m_ImageFile = value;
        this.reset();
    }

    public PlaceholderFile getImageFile() {
        return this.m_ImageFile;
    }

    public String imageFileTipText() {
        return "The image file to overlay.";
    }

    public void setScale(double value) {
        this.m_Scale = value;
        this.reset();
    }

    public double getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scaling factor for the image; 1.0 = actual size of image.";
    }

    @Override
    protected int getHeight() {
        if (this.m_Image != null) {
            return (int)((double)this.m_Image.getIconHeight() * this.m_Scale);
        }
        return 0;
    }

    @Override
    protected int getWidth() {
        if (this.m_Image != null) {
            return (int)((double)this.m_Image.getIconWidth() * this.m_Scale);
        }
        return 0;
    }

    @Override
    protected void prePaintOverlay(OpenStreetMapViewer viewer, Graphics g) {
        super.prePaintOverlay(viewer, g);
        if (this.m_Image == null) {
            if (!this.m_ImageFile.exists()) {
                this.getLogger().severe("Image file does not exist: " + this.m_ImageFile);
                return;
            }
            if (this.m_ImageFile.isDirectory()) {
                this.getLogger().severe("Image file points to a directory: " + this.m_ImageFile);
                return;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Loading: " + this.m_ImageFile);
            }
            this.m_Image = new ImageIcon(this.m_ImageFile.getAbsolutePath());
        }
    }

    @Override
    protected void doPaintOverlay(OpenStreetMapViewer viewer, Graphics g, int x, int y) {
        g.drawImage(this.m_Image.getImage(), x, y - this.getHeight(), this.getWidth(), this.getHeight(), null);
    }
}

