/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.osm;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxTree;

public class OpenStreetMapViewerTree
extends JMapViewerTree {
    private static final long serialVersionUID = -812585623709137784L;
    protected boolean m_FixCheckBoxTree = true;

    public OpenStreetMapViewerTree(String name) {
        super(name);
    }

    public OpenStreetMapViewerTree(String name, boolean treeVisible) {
        super(name, treeVisible);
    }

    public void setTreeVisible(boolean visible) {
        super.setTreeVisible(visible);
        if (visible && this.m_FixCheckBoxTree) {
            this.m_FixCheckBoxTree = false;
            this.fixCheckBoxTree();
        }
    }

    protected void fixCheckBoxTree() {
        CheckBoxTree cbtree = this.getTree();
        JPanel parent = (JPanel)cbtree.getParent();
        parent.remove((Component)cbtree);
        BaseScrollPane scrollpane = new BaseScrollPane((Component)cbtree);
        parent.add((Component)scrollpane, "Center");
    }

    public boolean setDividerLocation(int location) {
        JSplitPane splitpane = (JSplitPane)GUIHelper.findFirstComponent((Container)((Object)this), JSplitPane.class, (boolean)true, (boolean)true);
        if (splitpane != null) {
            splitpane.setDividerLocation(location);
            return true;
        }
        return false;
    }

    public int getDividerLocation() {
        JSplitPane splitpane = (JSplitPane)GUIHelper.findFirstComponent((Container)((Object)this), JSplitPane.class, (boolean)true, (boolean)true);
        if (splitpane != null) {
            return splitpane.getDividerLocation();
        }
        return -1;
    }

    protected void getLayers(TreeNode node, List<AbstractLayer> layers) {
        CheckBoxNodeData data;
        Object obj;
        if (node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof CheckBoxNodeData && (data = (CheckBoxNodeData)obj).getAbstractLayer() != null) {
            layers.add(data.getAbstractLayer());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            this.getLayers(child, layers);
        }
    }

    public List<AbstractLayer> getLayers() {
        ArrayList<AbstractLayer> result = new ArrayList<AbstractLayer>();
        this.getLayers((TreeNode)this.getTree().getModel().getRoot(), result);
        return result;
    }

    public List<AbstractLayer> getVisibleLayers() {
        ArrayList<AbstractLayer> result = new ArrayList<AbstractLayer>();
        List<AbstractLayer> layers = this.getLayers();
        for (AbstractLayer layer : layers) {
            if (layer.isVisible() == null || !layer.isVisible().booleanValue()) continue;
            result.add(layer);
        }
        return result;
    }

    public boolean isLayerVisible(String name) {
        List<AbstractLayer> layers = this.getLayers();
        for (AbstractLayer layer : layers) {
            if (!layer.getName().equals(name)) continue;
            return layer.isVisible();
        }
        return false;
    }
}

