/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.mapobject.AbstractMapObjectGenerator;
import adams.data.mapobject.MetaDataSupporter;
import adams.data.mapobject.TimestampSupporter;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public abstract class AbstractReportMapObjectGenerator<T extends MapObject>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -9173206961610198326L;
    protected String m_Layer;
    protected Field m_Timestamp;
    protected Field[] m_AdditionalAttributes;
    protected DateFormat m_DateFormat;
    protected DateFormat m_DateTimeFormat;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("layer", "layer", (Object)this.getDefaultLayer());
    }

    protected void initialize() {
        super.initialize();
        this.m_Timestamp = new Field("timestamp", DataType.STRING);
        this.m_AdditionalAttributes = new Field[0];
        this.m_DateFormat = DateUtils.getDateFormatter();
        this.m_DateTimeFormat = DateUtils.getTimestampFormatter();
    }

    protected String getDefaultLayer() {
        return "Default";
    }

    public void setLayer(String value) {
        this.m_Layer = value;
        this.reset();
    }

    public String getLayer() {
        return this.m_Layer;
    }

    public String layerTipText() {
        return "The name of the layer.";
    }

    public void setTimestamp(Field value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public Field getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The field to obtain the timestamp from for the map object (optional).";
    }

    public void setAdditionalAttributes(Field[] value) {
        this.m_AdditionalAttributes = value;
        this.reset();
    }

    public Field[] getAdditionalAttributes() {
        return this.m_AdditionalAttributes;
    }

    public String additionalAttributesTipText() {
        return "The fields to add to the map object as well.";
    }

    public abstract Class generates();

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"layer", (Object)this.m_Layer, (String)"Layer: ");
    }

    protected void check(Report report) {
        if (report == null) {
            throw new IllegalArgumentException("No report supplied!");
        }
    }

    protected double getNumericValue(Report report, Field field) {
        double result = Double.NaN;
        if (report.hasValue((AbstractField)field)) {
            Object obj = report.getValue((AbstractField)field);
            if (obj instanceof String) {
                try {
                    result = Double.parseDouble((String)obj);
                }
                catch (Exception e) {
                    result = Double.NaN;
                }
            } else if (obj instanceof Number) {
                result = ((Number)obj).doubleValue();
            }
        }
        return result;
    }

    protected void addTimestamp(Report report, TimestampSupporter mapobject) {
        if (!report.hasField((AbstractField)this.m_Timestamp)) {
            return;
        }
        mapobject.setTimestamp(this.m_DateFormat.parse(report.getStringValue((AbstractField)this.m_Timestamp)));
    }

    protected void addMetaData(Report report, MetaDataSupporter mapobject) {
        for (Field field : this.m_AdditionalAttributes) {
            if (!report.hasField((AbstractField)field)) {
                return;
            }
            mapobject.addMetaData(field.getName(), report.getValue((AbstractField)field));
        }
    }

    protected void postProcess(Report report, MapObject mapobject) {
        if (mapobject instanceof MetaDataSupporter) {
            this.addMetaData(report, (MetaDataSupporter)mapobject);
        }
        if (mapobject instanceof TimestampSupporter) {
            this.addTimestamp(report, (TimestampSupporter)mapobject);
        }
    }

    protected abstract T doGenerate(Report var1);

    public T generate(Report report) {
        this.check(report);
        T result = this.doGenerate(report);
        return result;
    }

    public AbstractMapObjectGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractMapObjectGenerator shallowCopy(boolean expand) {
        return (AbstractMapObjectGenerator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }
}

