/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractReportMapMarkerGenerator;
import adams.data.mapobject.SimpleMapMarkerDot;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.core.Fonts;
import java.awt.Color;
import java.awt.Font;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class SimpleReportDotMarkerGenerator
extends AbstractReportMapMarkerGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected int m_Radius;
    protected Field m_Name;
    protected Color m_FillColor;
    protected Font m_Font;
    protected Color m_DotColor;

    public String globalInfo() {
        return "Generates dot markers.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("radius", "radius", (Object)5, (Number)1, null);
        this.m_OptionManager.add("name", "name", (Object)new Field("name", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("timestamp", DataType.STRING));
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new Field[0]);
        this.m_OptionManager.add("dot-color", "dotColor", (Object)Color.ORANGE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(100, 100, 100, 50));
        this.m_OptionManager.add("font", "font", (Object)Fonts.getSansFont());
    }

    public void setRadius(int value) {
        this.m_Radius = value;
        this.reset();
    }

    public int getRadius() {
        return this.m_Radius;
    }

    public String radiusTipText() {
        return "The radius of the dot in pixels.";
    }

    public void setName(Field value) {
        this.m_Name = value;
        this.reset();
    }

    public Field getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The field containing the name (optional).";
    }

    public void setDotColor(Color value) {
        this.m_DotColor = value;
        this.reset();
    }

    public Color getDotColor() {
        return this.m_DotColor;
    }

    public String dotColorTipText() {
        return "The dot color for the point.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the point.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected MapMarker doGenerate(Report report) {
        SimpleMapMarkerDot result = null;
        double lat = this.getNumericValue(report, this.m_Latitude);
        double lon = this.getNumericValue(report, this.m_Longitude);
        result = new SimpleMapMarkerDot(new Layer(this.m_Layer), new Coordinate(lat, lon));
        result.setRadius(this.m_Radius);
        if (report.hasValue((AbstractField)this.m_Name)) {
            String name = report.getStringValue((AbstractField)this.m_Name);
            result.setName(name);
        }
        result.setBackColor(this.m_FillColor);
        result.setColor(this.m_DotColor);
        result.setFont(this.m_Font);
        this.postProcess(report, result);
        return result;
    }
}

