/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetJoinColumns;
import adams.data.conversion.SpreadSheetStringColumnToObject;
import adams.data.conversion.SpreadSheetToMapObjects;
import adams.data.conversion.mapobject.SimpleDotMarkerGenerator;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.GPSDecimalDegrees;
import adams.data.spreadsheet.GPSObjectHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.sink.OpenStreetMapViewer;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapCachedLoader;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapSource;
import adams.flow.sink.openstreetmapviewer.TableMapObjectHitListener;
import adams.flow.source.StorageValue;
import adams.flow.transformer.Convert;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.DescriptionPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class OpenStreetMapView
extends AbstractViewPlugin {
    private static final long serialVersionUID = 3096161473182386994L;
    public static final String KEY_META_DATA_COLUMNS = "Meta-data columns";
    public static final String KEY_FORMAT = "Format";
    public static final String KEY_GPS = "GPS";
    public static final String KEY_LONGITUDE = "Longitude";
    public static final String KEY_LATITUDE = "Latitude";
    public static final String STORAGE_NAME = "sheet";

    public String globalInfo() {
        return "Displays the GIS data in OpenStreetMap (OSM).";
    }

    public String getMenuText() {
        return "OpenStreetMap";
    }

    public String getMenuIcon() {
        return "osm.png";
    }

    public boolean requiresButtons() {
        return false;
    }

    protected BasePanel doGenerate(final SpreadSheet sheet) {
        final DescriptionPanel result = new DescriptionPanel((LayoutManager)new BorderLayout());
        result.setDescription("Select either the Latitude and Longitude columns or the column with the GPS data.", false);
        result.setDescriptionHeight(50);
        ArrayList<String> order = new ArrayList<String>();
        List names = sheet.getColumnNames();
        names.add(0, "");
        String[] cols = names.toArray(new String[0]);
        Properties props = new Properties();
        final PropertiesParameterPanel propsPanel = new PropertiesParameterPanel();
        String key = KEY_LATITUDE;
        propsPanel.addPropertyType(key, PropertiesParameterPanel.PropertyType.LIST);
        propsPanel.setList(key, cols);
        props.setProperty(key, cols[0]);
        order.add(key);
        key = KEY_LONGITUDE;
        propsPanel.addPropertyType(key, PropertiesParameterPanel.PropertyType.LIST);
        propsPanel.setList(key, cols);
        props.setProperty(key, cols[0]);
        order.add(key);
        key = KEY_GPS;
        propsPanel.addPropertyType(key, PropertiesParameterPanel.PropertyType.LIST);
        propsPanel.setList(key, cols);
        props.setProperty(key, cols[0]);
        order.add(key);
        key = KEY_FORMAT;
        propsPanel.addPropertyType(key, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        propsPanel.setChooser(key, (AbstractChooserPanel)new GenericObjectEditorPanel(AbstractObjectHandler.class, (Object)new GPSDecimalDegrees(), true));
        props.setProperty(key, OptionUtils.getCommandLine((Object)new GPSDecimalDegrees()));
        order.add(key);
        key = KEY_META_DATA_COLUMNS;
        propsPanel.addPropertyType(key, PropertiesParameterPanel.PropertyType.STRING);
        props.setProperty(key, "");
        order.add(key);
        propsPanel.setPropertyOrder(order);
        propsPanel.setProperties(props);
        result.add((Component)propsPanel, (Object)"Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        result.add((Component)panel, (Object)"South");
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenStreetMapView.this.display(propsPanel.getProperties(), sheet);
            }
        });
        panel.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result.closeParent();
            }
        });
        panel.add(buttonCancel);
        return result;
    }

    protected Flow generateFlow(String name, Properties props, SpreadSheet sheet) throws Exception {
        boolean swapped;
        Convert conv;
        Flow result = new Flow();
        if (sheet.getName() != null) {
            result.setName(sheet.getName());
        }
        StorageValue sv = new StorageValue();
        sv.setStorageName(new StorageName(STORAGE_NAME));
        result.add((Actor)sv);
        String gps = props.getProperty(KEY_GPS, "").trim();
        if (gps.isEmpty()) {
            String lat = props.getProperty(KEY_LATITUDE, "").trim();
            String lon = props.getProperty(KEY_LONGITUDE, "").trim();
            if (lat.isEmpty() || lon.isEmpty()) {
                GUIHelper.showErrorMessage((Component)this.m_CurrentPanel, (String)"If no GPS column is selected both column, latitude and longitude, must be provided");
                result.destroy();
                return null;
            }
            SpreadSheetColumnIndex index = new SpreadSheetColumnIndex();
            index.setData((Object)sheet);
            index.setIndex(lat);
            int latIndex = index.getIntIndex();
            index.setIndex(lon);
            int lonIndex = index.getIntIndex();
            if (latIndex == lonIndex) {
                GUIHelper.showErrorMessage((Component)this.m_CurrentPanel, (String)"Latitude and longitude columns are the same!");
                result.destroy();
                return null;
            }
            conv = new Convert();
            SpreadSheetJoinColumns join = new SpreadSheetJoinColumns();
            join.setColumns(new SpreadSheetColumnRange(latIndex + 1 + "," + (lonIndex + 1)));
            join.setGlue(" ");
            join.setColumnName("gps");
            conv.setConversion((Conversion)join);
            conv.setName("join " + lat + " and " + lon);
            result.add((Actor)conv);
            swapped = latIndex > lonIndex;
        } else {
            swapped = false;
        }
        conv = new Convert();
        SpreadSheetStringColumnToObject cto = new SpreadSheetStringColumnToObject();
        if (!gps.isEmpty()) {
            cto.setColumn(new SpreadSheetColumnIndex(gps));
        } else {
            cto.setColumn(new SpreadSheetColumnIndex("gps"));
        }
        AbstractObjectHandler handler = (AbstractObjectHandler)OptionUtils.forAnyCommandLine(AbstractObjectHandler.class, (String)props.getProperty(KEY_FORMAT, ""));
        if (!(handler instanceof GPSObjectHandler)) {
            GUIHelper.showErrorMessage((Component)this.m_CurrentPanel, (String)("You have to select a format that converts GPS strings into objects!\nSelected: " + OptionUtils.getCommandLine((Object)handler)));
            result.destroy();
            return null;
        }
        ((GPSObjectHandler)handler).setSwapped(swapped);
        cto.setHandler(handler);
        conv.setConversion((Conversion)cto);
        conv.setName("generate GPS objects");
        result.add((Actor)conv);
        conv = new Convert();
        SpreadSheetToMapObjects map = new SpreadSheetToMapObjects();
        SimpleDotMarkerGenerator generator = new SimpleDotMarkerGenerator();
        generator.setLayer(name);
        if (!gps.isEmpty()) {
            generator.setGPS(new SpreadSheetColumnIndex(gps));
        } else {
            generator.setGPS(new SpreadSheetColumnIndex("gps"));
        }
        String meta = props.getProperty(KEY_META_DATA_COLUMNS, "");
        if (!meta.isEmpty()) {
            generator.setAdditionalAttributes(new SpreadSheetColumnRange(meta));
        }
        map.setGenerator(generator);
        conv.setConversion((Conversion)map);
        conv.setName("generate map objects");
        result.add((Actor)conv);
        OpenStreetMapViewer osm = new OpenStreetMapViewer();
        osm.setName(name);
        osm.setShortTitle(true);
        osm.setTileSource(new OpenStreetMapSource());
        osm.setTileLoader(new OpenStreetMapCachedLoader());
        osm.setHitListener(new TableMapObjectHitListener());
        osm.setInitialZoom(1);
        osm.setZoomControls(true);
        osm.setLayerTree(true);
        osm.setLayers(new BaseString[]{new BaseString(name)});
        result.add((Actor)osm);
        result.getStorage().put(new StorageName(STORAGE_NAME), (Object)sheet);
        if (LoggingHelper.isAtLeast((Level)this.getLoggingLevel().getLevel(), (Level)Level.FINE)) {
            this.getLogger().fine(result.toCommandLine());
        }
        return result;
    }

    protected void display(Properties props, SpreadSheet sheet) {
        Flow flow;
        try {
            flow = this.generateFlow(FileUtils.replaceExtension((String)this.m_CurrentPanel.getTabTitle(), (String)""), props, sheet);
            if (flow == null) {
                return;
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.m_CurrentPanel, (String)("Failed to generate flow for GIS data display!\n" + Utils.throwableToString((Throwable)e)));
            return;
        }
        flow.setParentComponent((Component)this.m_CurrentPanel);
        SwingWorker worker = new SwingWorker(){
            String msg = null;

            protected Object doInBackground() throws Exception {
                this.msg = flow.setUp();
                if (this.msg != null) {
                    this.msg = "Failed to setup flow for generating GIS display:\n" + this.msg;
                }
                if (this.msg == null) {
                    this.msg = flow.execute();
                    if (this.msg != null) {
                        this.msg = "Failed to execute flow for generating GIS display:\n" + this.msg;
                    }
                }
                if (this.msg == null) {
                    flow.wrapUp();
                    if (flow.hasStopMessage()) {
                        this.msg = "Flow execution for generating GIS display was stopped:\n" + flow.getStopMessage();
                    }
                }
                return this.msg;
            }

            @Override
            protected void done() {
                super.done();
                if (this.msg != null) {
                    GUIHelper.showErrorMessage((Component)OpenStreetMapView.this.m_CurrentPanel, (String)this.msg);
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, this.msg + "\n");
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, flow.toCommandLine() + "\n");
                    flow.destroy();
                } else {
                    OpenStreetMapView.this.m_Panel.closeParent();
                    OpenStreetMapView.this.m_CurrentPanel.addGeneratedFlow(flow);
                }
            }
        };
        worker.execute();
    }
}

