/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractReportMapPolygonGenerator;
import adams.data.mapobject.SimpleMapPolygon;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.core.Fonts;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public class SimpleReportPolygonGenerator
extends AbstractReportMapPolygonGenerator {
    private static final long serialVersionUID = -8981130970653219268L;
    protected Field m_Name;
    protected Color m_BorderColor;
    protected Color m_FillColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Generates polygons.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)new Field("name", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("timestamp", DataType.STRING));
        this.m_OptionManager.add("additional-attributes", "additionalAttributes", (Object)new Field[0]);
        this.m_OptionManager.add("border-color", "borderColor", (Object)Color.BLUE);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(100, 100, 100, 50));
        this.m_OptionManager.add("font", "font", (Object)Fonts.getSansFont());
    }

    public void setName(Field value) {
        this.m_Name = value;
        this.reset();
    }

    public Field getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The field containing the name (optional).";
    }

    public void setBorderColor(Color value) {
        this.m_BorderColor = value;
        this.reset();
    }

    public Color getBorderColor() {
        return this.m_BorderColor;
    }

    public String borderColorTipText() {
        return "The border color for the polygon.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color for the polygon.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)", name: ");
        return result;
    }

    @Override
    protected MapPolygon doGenerate(Report report) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (int i = 0; i < this.m_Latitudes.length; ++i) {
            double lat = this.getNumericValue(report, this.m_Latitudes[i]);
            double lon = this.getNumericValue(report, this.m_Longitudes[i]);
            coords.add(new Coordinate(lat, lon));
        }
        SimpleMapPolygon result = new SimpleMapPolygon(new Layer(this.m_Layer), coords);
        if (report.hasValue((AbstractField)this.m_Name)) {
            String name = report.getStringValue((AbstractField)this.m_Name);
            result.setName(name);
        }
        result.setBackColor(this.m_FillColor);
        result.setColor(this.m_BorderColor);
        result.setFont(this.m_Font);
        this.postProcess(report, result);
        return result;
    }
}

