/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.flow.sink.openstreetmapviewer.AbstractMapObjectPruner;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;

public class SimplePruner
extends AbstractMapObjectPruner {
    private static final long serialVersionUID = -135743438219473331L;
    protected int m_MaxMarkers;
    protected int m_MaxRectangles;
    protected int m_MaxPolygons;

    public String globalInfo() {
        return "Prunes according to a simple upper limit of objects, removing the older ones.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-markers", "maxMarkers", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-rectangles", "maxRectangles", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-polygons", "maxPolygons", (Object)-1, (Number)-1, null);
    }

    public void setMaxMarkers(int value) {
        if (value >= -1) {
            this.m_MaxMarkers = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum for Markers must be at least -1, provided: " + value);
        }
    }

    public int getMaxMarkers() {
        return this.m_MaxMarkers;
    }

    public String maxMarkersTipText() {
        return "The maximum number of markers to keep; -1 for unlimited.";
    }

    public void setMaxRectangles(int value) {
        if (value >= -1) {
            this.m_MaxRectangles = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum for Rectangles must be at least -1, provided: " + value);
        }
    }

    public int getMaxRectangles() {
        return this.m_MaxRectangles;
    }

    public String maxRectanglesTipText() {
        return "The maximum number of rectangles to keep; -1 for unlimited.";
    }

    public void setMaxPolygons(int value) {
        if (value >= -1) {
            this.m_MaxPolygons = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum for Polygons must be at least -1, provided: " + value);
        }
    }

    public int getMaxPolygons() {
        return this.m_MaxPolygons;
    }

    public String maxPolygonsTipText() {
        return "The maximum number of polygons to keep; -1 for unlimited.";
    }

    @Override
    protected void doPrune(JMapViewerTree tree) {
        int pruned;
        if (this.m_MaxMarkers > -1) {
            pruned = 0;
            while (tree.getViewer().getMapMarkerList().size() > this.m_MaxMarkers) {
                tree.getViewer().getMapMarkerList().remove(0);
                ++pruned;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Markers pruned: " + pruned);
            }
        }
        if (this.m_MaxRectangles > -1) {
            pruned = 0;
            while (tree.getViewer().getMapRectangleList().size() > this.m_MaxRectangles) {
                tree.getViewer().getMapRectangleList().remove(0);
                ++pruned;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Rectangles pruned: " + pruned);
            }
        }
        if (this.m_MaxPolygons > -1) {
            pruned = 0;
            while (tree.getViewer().getMapPolygonList().size() > this.m_MaxPolygons) {
                tree.getViewer().getMapPolygonList().remove(0);
                ++pruned;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Polygons pruned: " + pruned);
            }
        }
    }
}

