/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractReportMapObjectGenerator;
import adams.data.report.Field;
import adams.data.report.Report;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public abstract class AbstractReportMapPolygonGenerator
extends AbstractReportMapObjectGenerator<MapPolygon> {
    private static final long serialVersionUID = -8754565176631384914L;
    protected Field[] m_Latitudes;
    protected Field[] m_Longitudes;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("latitude", "latitudes", (Object)new Field[0]);
        this.m_OptionManager.add("longitude", "longitudes", (Object)new Field[0]);
    }

    public void setLatitudes(Field[] value) {
        this.m_Latitudes = value;
        this.reset();
    }

    public Field[] getLatitudes() {
        return this.m_Latitudes;
    }

    public String latitudesTipText() {
        return "The fields containing the latitudes for the polygons.";
    }

    public void setLongitudes(Field[] value) {
        this.m_Longitudes = value;
        this.reset();
    }

    public Field[] getLongitudes() {
        return this.m_Longitudes;
    }

    public String longitudesTipText() {
        return "The fields containing the longitudes for the polygons.";
    }

    @Override
    public Class generates() {
        return MapPolygon.class;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"latitudes", (Object)this.m_Latitudes, (String)", lat: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"longitudes", (Object)this.m_Longitudes, (String)", lon: ");
        return result;
    }

    @Override
    protected void check(Report report) {
        super.check(report);
        if (this.m_Latitudes.length != this.m_Longitudes.length) {
            throw new IllegalStateException("Number of fields for lat and lon differ: " + this.m_Latitudes.length + " != " + this.m_Longitudes.length);
        }
        if (this.m_Latitudes.length < 3) {
            throw new IllegalStateException("At least three corners of a polygon are required, provided: " + this.m_Latitudes.length);
        }
    }
}

