/*
 * Decompiled with CFR 0.152.
 */
package adams.data.mapobject;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.annotation.ThirdPartyCopyright;
import adams.data.mapobject.AbstractMapObject;
import adams.data.mapobject.HitIndicator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

@MixedCopyright(copyright="OpenStreetMap", author="Vincent", license=License.GPL2, url="http://svn.openstreetmap.org/applications/viewer/jmapviewer/releases/1.02/JMapViewer-1.02-Source.zip", note="Original class: org.openstreetmap.gui.jmapviewer.MapPolygonImpl")
public class SimpleMapPolygon
extends AbstractMapObject
implements MapPolygon,
HitIndicator {
    private List<? extends ICoordinate> points;

    public SimpleMapPolygon(ICoordinate ... points) {
        this((Layer)null, (String)null, points);
    }

    public SimpleMapPolygon(List<? extends ICoordinate> points) {
        this(null, null, points);
    }

    public SimpleMapPolygon(String name, List<? extends ICoordinate> points) {
        this(null, name, points);
    }

    public SimpleMapPolygon(String name, ICoordinate ... points) {
        this(null, name, points);
    }

    public SimpleMapPolygon(Layer layer, List<? extends ICoordinate> points) {
        this(layer, null, points);
    }

    public SimpleMapPolygon(Layer layer, String name, List<? extends ICoordinate> points) {
        this(layer, name, points, SimpleMapPolygon.getDefaultStyle());
    }

    public SimpleMapPolygon(Layer layer, String name, ICoordinate ... points) {
        this(layer, name, Arrays.asList(points), SimpleMapPolygon.getDefaultStyle());
    }

    public SimpleMapPolygon(Layer layer, String name, List<? extends ICoordinate> points, Style style) {
        super(layer, name, style);
        this.points = points;
    }

    public List<? extends ICoordinate> getPoints() {
        return this.points;
    }

    public void paint(Graphics g, List<Point> points) {
        Polygon polygon = new Polygon();
        for (Point p : points) {
            polygon.addPoint(p.x, p.y);
        }
        this.paint(g, polygon);
    }

    public void paint(Graphics g, Polygon polygon) {
        Graphics2D g2;
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldStroke = g2.getStroke();
            g2.setStroke(this.getStroke());
        }
        g.drawPolygon(polygon);
        if (g instanceof Graphics2D && this.getBackColor() != null) {
            g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3));
            g2.setPaint(this.getBackColor());
            g2.fillPolygon(polygon);
            g2.setComposite(oldComposite);
        }
        g.setColor(oldColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
        Rectangle rec = polygon.getBounds();
        Point corner = rec.getLocation();
        Point p = new Point(corner.x + rec.width / 2, corner.y + rec.height / 2);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(g, p);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLUE, new Color(100, 100, 100, 50), (Stroke)new BasicStroke(2.0f), SimpleMapPolygon.getDefaultFont());
    }

    @Override
    @ThirdPartyCopyright(copyright="1970-2003 Wm. Randolph Franklin", license=License.BSD3, url="http://stackoverflow.com/a/2212851")
    public boolean isHit(JMapViewer viewer, Coordinate coord) {
        boolean result = false;
        int i = 0;
        int j = this.points.size() - 1;
        while (i < this.points.size()) {
            if (this.points.get(i).getLat() > coord.getLat() != this.points.get(j).getLat() > coord.getLat() && coord.getLon() < (this.points.get(j).getLon() - this.points.get(i).getLon()) * (coord.getLat() - this.points.get(i).getLat()) / (this.points.get(j).getLat() - this.points.get(i).getLat()) + this.points.get(i).getLon()) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public String toString() {
        return "Polygon: name=" + this.getName() + ", coords=" + this.getPoints() + ", meta=" + this.getMetaData();
    }
}

