/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.flow.core.ActorUtils;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectHitListener;
import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public abstract class AbstractMapObjectHitListenerWithDialog<T extends Dialog>
extends AbstractMapObjectHitListener {
    private static final long serialVersionUID = -613241778857988225L;
    protected String m_Title;
    protected int m_Width;
    protected int m_Height;
    protected int m_X;
    protected int m_Y;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title", "title", (Object)this.getDefaultTitle());
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)-1, null);
        this.m_OptionManager.add("x", "x", (Object)this.getDefaultX(), (Number)-3, null);
        this.m_OptionManager.add("y", "y", (Object)this.getDefaultY(), (Number)-3, null);
    }

    protected String getDefaultTitle() {
        return "Hits";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title of the dialog.";
    }

    protected int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    protected int getDefaultX() {
        return -2;
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the dialog (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    protected int getDefaultY() {
        return -2;
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the dialog (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    protected abstract T doProcessHits(JMapViewer var1, List<MapObject> var2);

    @Override
    protected void processHits(JMapViewer viewer, List<MapObject> hits) {
        T dialog = this.doProcessHits(viewer, hits);
        ((Window)dialog).setSize(ActorUtils.determineSize(dialog, (int)this.m_X, (int)this.m_Y, (int)this.m_Width, (int)this.m_Height));
        ((Window)dialog).setLocation(ActorUtils.determineLocation(dialog, (int)this.m_X, (int)this.m_Y));
        ((Dialog)dialog).setVisible(true);
    }
}

