/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.osm;

import adams.core.Properties;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.GPSDecimalDegrees;
import adams.flow.sink.openstreetmapviewer.AbstractTileLoaderProvider;
import adams.flow.sink.openstreetmapviewer.AbstractTileSourceProvider;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapLoader;
import adams.flow.sink.openstreetmapviewer.OpenStreetMapSource;
import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.osm.OpenStreetMapViewerTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class OpenStreetMapViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -433042545597419167L;
    protected JMenuBar m_MenuBar;
    protected OpenStreetMapViewerTree m_Viewer;
    protected String m_LastCoordinates;
    protected Properties m_Properties;
    protected GenericObjectEditorDialog m_GOEDialogSource;
    protected AbstractTileSourceProvider m_CurrentSource;
    protected GenericObjectEditorDialog m_GOEDialogLoader;
    protected AbstractTileLoaderProvider m_CurrentLoader;

    protected void initialize() {
        super.initialize();
        Properties props = this.getProperties();
        this.m_LastCoordinates = props.getProperty("Coordinates", "0, 0");
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        Properties props = this.getProperties();
        this.m_Viewer = new OpenStreetMapViewerTree(props.getProperty("LayerRoot", "Layers"));
        this.m_Viewer.setTreeVisible(props.getBoolean("LayerTreeVisible", Boolean.valueOf(false)));
        this.m_Viewer.setDividerLocation(props.getInteger("DividerLocation", Integer.valueOf(150)));
        this.m_Viewer.getViewer().setZoom(props.getInteger("Zoom", Integer.valueOf(1)).intValue());
        this.m_Viewer.getViewer().setZoomContolsVisible(props.getBoolean("ZoomControlsVisible", Boolean.valueOf(true)).booleanValue());
        this.m_Viewer.getViewer().setTileGridVisible(props.getBoolean("TileGridVisible", Boolean.valueOf(false)).booleanValue());
        this.m_CurrentSource = new OpenStreetMapSource();
        try {
            this.m_CurrentSource = (AbstractTileSourceProvider)((Object)OptionUtils.forAnyCommandLine(AbstractTileSourceProvider.class, (String)props.getProperty("TileSourceProvider", OptionUtils.getCommandLine((Object)((Object)this.m_CurrentSource)))));
            this.m_Viewer.getViewer().setTileSource(this.m_CurrentSource.generate());
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)this, "Failed to use tile source from provider: " + props.getProperty("TileSourceProvider"), (Throwable)e);
            this.m_Viewer.getViewer().setTileSource((TileSource)new OsmTileSource.Mapnik());
        }
        this.m_CurrentLoader = new OpenStreetMapLoader();
        try {
            this.m_CurrentLoader = (AbstractTileLoaderProvider)((Object)OptionUtils.forAnyCommandLine(AbstractTileLoaderProvider.class, (String)props.getProperty("TileLoaderProvider", OptionUtils.getCommandLine((Object)((Object)this.m_CurrentLoader)))));
            this.m_Viewer.getViewer().setTileLoader(this.m_CurrentLoader.generate((TileLoaderListener)this.m_Viewer.getViewer()));
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)this, "Failed to use tile loader from provider: " + props.getProperty("TileLoaderProvider"), (Throwable)e);
            this.m_Viewer.getViewer().setTileLoader((TileLoader)new OsmTileLoader((TileLoaderListener)this.m_Viewer.getViewer()));
        }
        this.add((Component)((Object)this.m_Viewer), "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.setCenter(this.m_LastCoordinates);
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            JMenuBar result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OpenStreetMapViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Tile source...");
            menu.add(menuitem);
            menuitem.setMnemonic('s');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenStreetMapViewerPanel.this.selectTileSourceProvider();
                }
            });
            menuitem = new JMenuItem("Tile loader...");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenStreetMapViewerPanel.this.selectTileLoaderProvider();
                }
            });
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenStreetMapViewerPanel.this.close();
                }
            });
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OpenStreetMapViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Show tile grid");
            menu.add(menuitem);
            menuitem.setSelected(this.m_Viewer.getViewer().isTileGridVisible());
            menuitem.setMnemonic('g');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenStreetMapViewerPanel.this.m_Viewer.getViewer().setTileGridVisible(!OpenStreetMapViewerPanel.this.m_Viewer.getViewer().isTileGridVisible());
                }
            });
            menuitem = new JMenuItem("Show coordinates...");
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('c');
            menuitem.setIcon(GUIHelper.getIcon((String)"crosshair.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String coords = GUIHelper.showInputDialog((Component)((Object)OpenStreetMapViewerPanel.this), (String)"Please enter coordinates for centering the map in decimal notation ('lat [,] lon'):", (String)OpenStreetMapViewerPanel.this.m_LastCoordinates);
                    if (coords == null) {
                        return;
                    }
                    OpenStreetMapViewerPanel.this.setCenter(coords);
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
    }

    public void close() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public Class[] getSendToClasses() {
        return new Class[]{JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return true;
    }

    public Object getSendToItem(Class[] cls) {
        OpenStreetMapViewerTree result = null;
        if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls)) {
            result = this.m_Viewer;
        }
        return result;
    }

    public void setCenter(String coords) {
        GPSDecimalDegrees gps = new GPSDecimalDegrees(coords);
        this.setCenter((AbstractGPS)gps);
    }

    public void setCenter(AbstractGPS coords) {
        this.m_Viewer.getViewer().setDisplayPositionByLatLon(coords.getLatitude().toDecimal(), coords.getLongitude().toDecimal(), this.m_Viewer.getViewer().getZoom());
        this.m_LastCoordinates = coords.getLatitude().toDecimal() + ", " + coords.getLongitude().toDecimal();
    }

    public AbstractGPS getCenter() {
        Coordinate coords = this.m_Viewer.getViewer().getPosition();
        GPSDecimalDegrees result = new GPSDecimalDegrees(coords.getLat(), coords.getLon());
        return result;
    }

    public void selectTileSourceProvider() {
        if (this.m_GOEDialogSource == null) {
            this.m_GOEDialogSource = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEDialogSource.setTitle("Tile source provider");
            this.m_GOEDialogSource.getGOEEditor().setClassType(AbstractTileSourceProvider.class);
            this.m_GOEDialogSource.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEDialogSource.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_GOEDialogSource.setCurrent((Object)this.m_CurrentSource);
        this.m_GOEDialogSource.setVisible(true);
        if (this.m_GOEDialogSource.getResult() != 0) {
            return;
        }
        this.m_CurrentSource = (AbstractTileSourceProvider)((Object)this.m_GOEDialogSource.getCurrent());
        try {
            this.m_Viewer.getViewer().setTileSource(this.m_CurrentSource.generate());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to use tile source from provider: " + OptionUtils.getCommandLine((Object)((Object)this.m_CurrentSource)) + "\n" + LoggingHelper.throwableToString((Throwable)e)), (String)"Tile source provider");
        }
    }

    public void selectTileLoaderProvider() {
        if (this.m_GOEDialogLoader == null) {
            this.m_GOEDialogLoader = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEDialogLoader.setTitle("Tile loader provider");
            this.m_GOEDialogLoader.getGOEEditor().setClassType(AbstractTileLoaderProvider.class);
            this.m_GOEDialogLoader.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEDialogLoader.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_GOEDialogLoader.setCurrent((Object)this.m_CurrentLoader);
        this.m_GOEDialogLoader.setVisible(true);
        if (this.m_GOEDialogLoader.getResult() != 0) {
            return;
        }
        this.m_CurrentLoader = (AbstractTileLoaderProvider)((Object)this.m_GOEDialogLoader.getCurrent());
        try {
            this.m_Viewer.getViewer().setTileLoader(this.m_CurrentLoader.generate((TileLoaderListener)this.m_Viewer.getViewer()));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to use tile loader from provider: " + OptionUtils.getCommandLine((Object)((Object)this.m_CurrentLoader)) + "\n" + LoggingHelper.throwableToString((Throwable)e)), (String)"Tile loader provider");
        }
    }

    public synchronized Properties getProperties() {
        Properties result;
        try {
            if (this.m_Properties == null) {
                String props = ((Object)((Object)this)).getClass().getName().replaceAll("\\.", "/") + ".props";
                this.m_Properties = result = Properties.read((String)props);
            } else {
                result = this.m_Properties;
            }
        }
        catch (Exception e) {
            result = new Properties();
        }
        return result;
    }
}

