/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.MultiFileSupplier;
import adams.flow.transformer.PDFMerge;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFMergeTest
extends AbstractFlowTest {
    public PDFMergeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("page1.pdf");
        this.m_TestHelper.copyResourceToTmp("page2.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("page1.pdf");
        this.m_TestHelper.deleteFileFromTmp("page2.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
        super.tearDown();
    }

    public AbstractActor getActor() {
        MultiFileSupplier mfs = new MultiFileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("page1.pdf"), new TmpFile("page2.pdf")});
        mfs.setOutputArray(true);
        PDFMerge pdf = new PDFMerge();
        pdf.setOutput((PlaceholderFile)new TmpFile("dumpfile.pdf"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, pdf});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(PDFMergeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFMergeTest.runTest((Test)PDFMergeTest.suite());
    }
}

