/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.PDFExtractText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFExtractTextTest
extends AbstractFlowTest {
    public PDFExtractTextTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("multiple_pages.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("multiple_pages.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("multiple_pages.pdf"));
        PDFExtractText pdf = new PDFExtractText();
        pdf.setPages(new Range("first-last"));
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, pdf, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(PDFExtractTextTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFExtractTextTest.runTest((Test)PDFExtractTextTest.suite());
    }
}

