/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.PDFCreate;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFCreateTest
extends AbstractFlowTest {
    public PDFCreateTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts_small.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts_small.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts_small.csv")});
        PDFCreate pdf = new PDFCreate();
        pdf.setOutput((PlaceholderFile)new TmpFile("dumpfile.pdf"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, pdf});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(PDFCreateTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFCreateTest.runTest((Test)PDFCreateTest.suite());
    }
}

