/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfstamp;

import adams.core.io.PdfFont;
import adams.flow.transformer.pdfstamp.AbstractPageRangeStamper;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfStamper;

public class Text
extends AbstractPageRangeStamper {
    private static final long serialVersionUID = -2687932798037862212L;
    public static final String PLACEHOLDER_0PAGE = "#";
    public static final String PLACEHOLDER_1PAGE = "@";
    protected String m_Template;
    protected Alignment m_Alignment;
    protected PdfFont m_Font;
    protected float m_X;
    protected float m_Y;
    protected float m_Rotation;

    public String globalInfo() {
        return "Simple text stamper.\nYou can use placeholders for the page index:\n- 0-based: #\n- 1-based: @\nVariables in the template get expanded as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "template", (Object)"Page @");
        this.m_OptionManager.add("alignment", "alignment", (Object)Alignment.CENTER);
        this.m_OptionManager.add("font", "font", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("rotation", "rotation", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(360.0f));
    }

    public void setTemplate(String value) {
        this.m_Template = value;
        this.reset();
    }

    public String getTemplate() {
        return this.m_Template;
    }

    public String templateTipText() {
        return "The text template to use for the stamp.";
    }

    public void setAlignment(Alignment value) {
        this.m_Alignment = value;
        this.reset();
    }

    public Alignment getAlignment() {
        return this.m_Alignment;
    }

    public String alignmentTipText() {
        return "The alignment of the text.";
    }

    public void setFont(PdfFont value) {
        this.m_Font = value;
        this.reset();
    }

    public PdfFont getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    public void setX(float value) {
        this.m_X = value;
        this.reset();
    }

    public float getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position.";
    }

    public void setY(float value) {
        this.m_Y = value;
        this.reset();
    }

    public float getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position.";
    }

    public void setRotation(float value) {
        this.m_Rotation = value;
        this.reset();
    }

    public float getRotation() {
        return this.m_Rotation;
    }

    public String rotationTipText() {
        return "The rotation in degrees, counterclockwise.";
    }

    @Override
    protected void doStamp(PdfStamper stamper, int page) {
        String text = this.getOptionManager().getVariables().expand(this.m_Template);
        text = text.replace(PLACEHOLDER_0PAGE, "" + page);
        text = text.replace(PLACEHOLDER_1PAGE, "" + (page + 1));
        PdfContentByte canvas = stamper.getOverContent(page + 1);
        ColumnText.showTextAligned((PdfContentByte)canvas, (int)this.m_Alignment.getAlignment(), (Phrase)new Paragraph(text, this.m_Font.toFont()), (float)this.m_X, (float)this.m_Y, (float)this.m_Rotation);
    }

    public static enum Alignment {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        private int m_Alignment;

        private Alignment(int alignment) {
            this.m_Alignment = alignment;
        }

        public int getAlignment() {
            return this.m_Alignment;
        }
    }
}

