/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.JPod;
import adams.core.io.PDFBox;
import adams.core.io.PlaceholderFile;
import adams.gui.sendto.AbstractSendToAction;
import adams.gui.sendto.SendToActionUtils;
import de.intarsys.pdf.pd.PDDocument;
import java.io.File;

public class PDFPrinter
extends AbstractSendToAction {
    private static final long serialVersionUID = -6357616730945070639L;

    public String getAction() {
        return "Printer (PDF)";
    }

    public String getIconName() {
        return "print.gif";
    }

    public Class[] accepts() {
        return new Class[]{PDDocument.class, org.apache.pdfbox.pdmodel.PDDocument.class};
    }

    public String send(Object o) {
        String result = null;
        if (o instanceof PDDocument) {
            PlaceholderFile file = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf");
            if (JPod.save((PDDocument)o, (File)file)) {
                if (!PDFBox.print((File)file)) {
                    result = "Failed to print PDF document: " + file;
                }
            } else {
                result = "Failed to save PDF document to: " + file;
            }
        } else if (o instanceof org.apache.pdfbox.pdmodel.PDDocument) {
            if (!PDFBox.print((org.apache.pdfbox.pdmodel.PDDocument)o)) {
                result = "Failed to print PDF document";
            }
        } else {
            result = "Cannot print object: " + o.getClass();
        }
        return result;
    }
}

