/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfstamp;

import adams.core.Range;
import adams.flow.transformer.pdfstamp.AbstractStamper;
import com.itextpdf.text.pdf.PdfStamper;

public abstract class AbstractPageRangeStamper
extends AbstractStamper {
    private static final long serialVersionUID = -8844401168882904723L;
    protected Range m_Pages;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pages", "pages", (Object)new Range("first-last"));
    }

    public void setPages(Range value) {
        this.m_Pages = value;
        this.reset();
    }

    public Range getPages() {
        return this.m_Pages;
    }

    public String pagesTipText() {
        return "The pages to stamp.";
    }

    protected abstract void doStamp(PdfStamper var1, int var2);

    @Override
    protected void doStamp(PdfStamper stamper) {
        int[] pages;
        this.m_Pages.setMax(stamper.getReader().getNumberOfPages());
        for (int page : pages = this.m_Pages.getIntIndices()) {
            this.doStamp(stamper, page);
        }
    }
}

