/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.FileComparator;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.visualization.pdf.PDFViewerPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Documentation
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = -6548349613973153076L;

    public Documentation(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getTitle() {
        return "Documentation";
    }

    public String getIconName() {
        return "pdf.png";
    }

    public void launch() {
    }

    public JMenuItem getMenuItem() {
        ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
        for (PlaceholderDirectory dir : this.m_Owner.getDocumentationDirectories()) {
            String[] docs;
            DirectoryLister lister = new DirectoryLister();
            lister.setWatchDir(dir);
            lister.setListDirs(false);
            lister.setListFiles(true);
            lister.setRecursive(true);
            lister.setRegExp(new BaseRegExp(".*\\.[pP][dD][fF]$"));
            for (String doc : docs = lister.list()) {
                PlaceholderFile file = new PlaceholderFile(doc);
                if (files.contains(file)) continue;
                files.add(file);
            }
        }
        if (files.size() == 0) {
            return null;
        }
        Collections.sort(files, new FileComparator(false, true));
        JMenu result = new JMenu();
        result.setIcon(this.getIcon());
        result.setText(this.getTitle());
        for (final File file : files) {
            JMenuItem menuitem = new JMenuItem(FileUtils.replaceExtension((File)file, (String)"").getName());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel panel = new PDFViewerPanel();
                    Documentation.this.createChildFrame((Component)((Object)panel), 800, 600);
                    panel.load(file);
                }
            });
            result.add(menuitem);
        }
        return result;
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Help";
    }
}

