/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.JPod;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PDFExtractImages
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected List<BufferedImage> m_Images;

    public String globalInfo() {
        return "Actor for extracting the images from a PDF file.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Images = new ArrayList<BufferedImage>();
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImage.class};
    }

    protected String doExecute() {
        List<BufferedImage> content;
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Extracting images from '" + file + "'");
        }
        if ((content = JPod.extractImages(file)) == null) {
            result = "Failed to extract images from '" + file + "'!";
        } else {
            this.m_Images = new ArrayList<BufferedImage>(content);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Extracted #" + this.m_Images.size() + " images from '" + file + "'");
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Images.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Images.get(0));
        this.m_Images.remove(0);
        this.m_InputToken = null;
        return result;
    }
}

