/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.pdf;

import adams.core.Utils;
import adams.core.io.JPod;
import adams.gui.core.BasePanel;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.pdf.PDFCanvas;
import de.intarsys.pdf.pd.PDDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public class PDFPanel
extends BasePanel {
    private static final long serialVersionUID = -1994121429485824895L;
    public static final int[] ZOOMS = new int[]{25, 50, 66, 75, 100, 150, 200, 400, 800};
    protected PDFCanvas m_PDFCanvas;
    protected BaseScrollPane m_ScrollPane;
    protected BasePanel m_PanelNavigation;
    protected JTextField m_TextPage;
    protected JButton m_ButtonPrevious;
    protected JButton m_ButtonNext;
    protected PDDocument m_Document;
    protected JLabel m_LabelPages;

    protected void initialize() {
        super.initialize();
        this.m_Document = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        try {
            this.m_PDFCanvas = new PDFCanvas();
            this.m_PDFCanvas.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isRightClick((MouseEvent)e)) {
                        e.consume();
                        PDFPanel.this.showPopup(e);
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            this.m_ScrollPane = new BaseScrollPane((Component)this.m_PDFCanvas);
            this.add((Component)this.m_ScrollPane, "Center");
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate PDFPagePanel:");
            e.printStackTrace();
        }
        this.m_PanelNavigation = new BasePanel((LayoutManager)new FlowLayout(0));
        this.add((Component)this.m_PanelNavigation, "South");
        this.m_ButtonPrevious = new JButton(GUIHelper.getIcon((String)"arrow_left.gif"));
        this.m_ButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFPanel.this.previousPage();
            }
        });
        this.m_PanelNavigation.add((Component)this.m_ButtonPrevious);
        this.m_ButtonNext = new JButton(GUIHelper.getIcon((String)"arrow_right.gif"));
        this.m_ButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFPanel.this.nextPage();
            }
        });
        this.m_PanelNavigation.add((Component)this.m_ButtonNext);
        this.m_TextPage = new JTextField(5);
        this.m_TextPage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && Utils.isInteger((String)PDFPanel.this.m_TextPage.getText())) {
                    PDFPanel.this.showPage(Integer.parseInt(PDFPanel.this.m_TextPage.getText()) - 1);
                }
            }
        });
        this.m_PanelNavigation.add((Component)this.m_TextPage);
        this.m_LabelPages = new JLabel();
        this.m_PanelNavigation.add((Component)this.m_LabelPages);
        this.updateButtons();
    }

    protected void previousPage() {
        if (this.m_Document == null) {
            return;
        }
        this.m_PDFCanvas.selectPreviousPage();
        this.m_TextPage.setText("" + (this.m_PDFCanvas.getPageIndex() + 1));
        this.updateButtons();
    }

    protected void nextPage() {
        if (this.m_Document == null) {
            return;
        }
        this.m_PDFCanvas.selectNextPage();
        this.m_TextPage.setText("" + (this.m_PDFCanvas.getPageIndex() + 1));
        this.updateButtons();
    }

    protected void showPage(int pageNo) {
        if (pageNo >= 0 && pageNo < this.m_PDFCanvas.getPageCount()) {
            this.m_TextPage.setText("" + (pageNo + 1));
            this.m_PDFCanvas.selectPage(pageNo);
        }
        this.updateButtons();
    }

    public void setDocument(PDDocument value) {
        try {
            if (this.m_Document != null) {
                this.m_Document.close();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to close PDF document:");
            e.printStackTrace();
        }
        this.m_Document = value;
        if (this.m_Document != null) {
            this.m_PDFCanvas.setDoc(this.m_Document);
            this.m_LabelPages.setText(" of " + this.m_PDFCanvas.getPageCount());
            this.showPage(0);
        } else {
            this.m_LabelPages.setText("");
            this.m_TextPage.setText("");
            this.updateButtons();
        }
    }

    public PDDocument getDocument() {
        return this.m_Document;
    }

    public void closeDocument() {
        JPod.close(this.m_Document);
    }

    public void setScale(double value) {
        this.m_PDFCanvas.setScale(value);
    }

    public double getScale() {
        return this.m_PDFCanvas.getScale();
    }

    protected void updateButtons() {
        boolean loaded = this.m_Document != null && this.m_PDFCanvas.getPageCount() > 0;
        this.m_ButtonPrevious.setEnabled(loaded && this.m_PDFCanvas.getPageIndex() > 0);
        this.m_ButtonNext.setEnabled(loaded && this.m_PDFCanvas.getPageIndex() < this.m_PDFCanvas.getPageCount() - 1);
    }

    protected void showPopup(MouseEvent e) {
        BasePopupMenu menu = new BasePopupMenu();
        JMenuItem menuitem = new JMenuItem("Zoom in");
        menu.add(menuitem);
        menuitem.setMnemonic('i');
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFPanel.this.setScale(PDFPanel.this.getScale() * 1.5);
            }
        });
        menuitem = new JMenuItem("Zoom out");
        menu.add(menuitem);
        menuitem.setMnemonic('o');
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFPanel.this.setScale(PDFPanel.this.getScale() / 1.5);
            }
        });
        menu.addSeparator();
        for (int i = 0; i < ZOOMS.length; ++i) {
            final int fZoom = ZOOMS[i];
            menuitem = new JMenuItem(ZOOMS[i] + "%");
            menu.add(menuitem);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFPanel.this.setScale((double)fZoom / 100.0);
                }
            });
        }
        menu.showAbsolute(e.getComponent(), e);
    }
}

