/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.pdf;

import adams.core.Properties;
import adams.core.io.JPod;
import adams.core.io.PDFBox;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.pdf.PDFPanel;
import de.intarsys.pdf.pd.PDDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class PDFViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 1270944412770632645L;
    public static final String SESSION_FILE = "PDFViewerSession.props";
    protected static Properties m_Properties;
    protected TabbedPane m_TabbedPane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemFileExit;
    protected JMenu m_MenuViewZoom;
    protected JMenuItem m_MenuItemViewZoomIn;
    protected JMenuItem m_MenuItemViewZoomOut;
    protected transient BaseFileChooser m_FileChooser;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandler = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new TabbedPane();
        this.m_TabbedPane.setCloseTabsWithMiddleMouseButton(true);
        this.add((Component)((Object)this.m_TabbedPane), "Center");
    }

    protected BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            BaseFileChooser fileChooser = new BaseFileChooser();
            fileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPdfFileFilter());
            fileChooser.setDefaultExtension(ExtensionFileFilter.getPdfFileFilter().getExtensions()[0]);
            fileChooser.setMultiSelectionEnabled(true);
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PDFViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    PDFViewerPanel.this.load((File)e.getItem());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.closeFile();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Print...");
            menu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed P"));
            menuitem.setIcon(GUIHelper.getIcon((String)"print.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.printFile();
                }
            });
            this.m_MenuItemFilePrint = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PDFViewerPanel.this.updateMenu();
                }
            });
            submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setMnemonic('Z');
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            submenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PDFViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuViewZoom = submenu;
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed I"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.getCurrentPanel().setScale(PDFViewerPanel.this.getCurrentPanel().getScale() * 1.5);
                }
            });
            this.m_MenuItemViewZoomIn = menuitem;
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PDFViewerPanel.this.getCurrentPanel().setScale(PDFViewerPanel.this.getCurrentPanel().getScale() / 1.5);
                }
            });
            this.m_MenuItemViewZoomOut = menuitem;
            submenu.addSeparator();
            for (int i = 0; i < PDFPanel.ZOOMS.length; ++i) {
                final int fZoom = PDFPanel.ZOOMS[i];
                menuitem = new JMenuItem(PDFPanel.ZOOMS[i] + "%");
                submenu.add(menuitem);
                if (PDFPanel.ZOOMS[i] == 100) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"1"));
                } else if (PDFPanel.ZOOMS[i] == 200) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"2"));
                } else if (PDFPanel.ZOOMS[i] == 400) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"4"));
                }
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PDFViewerPanel.this.zoom(fZoom);
                    }
                });
            }
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public PDFPanel getCurrentPanel() {
        PDFPanel result = null;
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index >= 0) {
            result = (PDFPanel)((Object)this.m_TabbedPane.getComponentAt(index));
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean pdfAvailable = this.m_TabbedPane.getTabCount() > 0 && this.m_TabbedPane.getSelectedIndex() != -1;
        this.m_MenuItemFileClose.setEnabled(pdfAvailable);
        this.m_MenuItemFilePrint.setEnabled(pdfAvailable);
        this.m_MenuViewZoom.setEnabled(pdfAvailable);
        this.m_MenuItemViewZoomIn.setEnabled(pdfAvailable);
        this.m_MenuItemViewZoomOut.setEnabled(pdfAvailable);
    }

    protected void open() {
        PlaceholderFile[] files;
        int retVal = this.getFileChooser().showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : files = this.getFileChooser().getSelectedPlaceholderFiles()) {
            this.load((File)file);
        }
    }

    public void load(File file) {
        PDDocument document = JPod.load(file);
        if (document == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading PDF file:\n" + file));
        } else {
            PDFPanel panel = new PDFPanel();
            panel.setDocument(document);
            this.m_TabbedPane.addTab(file.getName(), (Component)((Object)panel));
            this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
            this.getFileChooser().setCurrentDirectory(file.getParentFile());
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem((Object)file);
            }
        }
    }

    protected void closeFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_TabbedPane.getPanelAt(index).closeDocument();
        this.m_TabbedPane.remove(index);
    }

    protected void printFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        PlaceholderFile file = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf");
        if (JPod.save(this.m_TabbedPane.getPanelAt(index).getDocument(), (File)file)) {
            if (!PDFBox.print((File)file)) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to print PDF document: " + file));
            }
        } else {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save PDF document to: " + file));
        }
    }

    protected void close() {
        this.closeParent();
    }

    protected void zoom(int zoom) {
        this.getCurrentPanel().setScale((double)zoom / 100.0);
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, PDDocument.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls) || SendToActionUtils.isAvailable(PDDocument.class, (Class[])cls)) && this.getCurrentPanel() != null && this.getCurrentPanel().getDocument() != null;
    }

    public Object getSendToItem(Class[] cls) {
        PlaceholderFile result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            if (this.getCurrentPanel().getDocument() != null) {
                result = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf");
                if (!JPod.save(this.getCurrentPanel().getDocument(), (File)result)) {
                    System.err.println("Failed to save PDF to '" + result + "'!");
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(PDDocument.class, (Class[])cls)) {
            result = this.getCurrentPanel().getDocument();
        }
        return result;
    }

    public static class TabbedPane
    extends BaseTabbedPane {
        private static final long serialVersionUID = -2048229771213837710L;

        public PDFPanel getPanelAt(int index) {
            PDFPanel result;
            if (this.getComponentAt(index) instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)this.getComponentAt(index);
                result = (PDFPanel)((Object)pane.getViewport().getView());
            } else {
                result = (PDFPanel)((Object)this.getComponentAt(index));
            }
            return result;
        }
    }
}

