/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DisplayPanelManager;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.ImageViewer;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.PDFRenderPages;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.NullOverlay;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import adams.gui.visualization.image.selection.NullProcessor;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFRenderPagesTest
extends AbstractFlowTest {
    public PDFRenderPagesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("multiple_images.pdf");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("multiple_images.pdf");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(PDFRenderPagesTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/multiple_images.pdf"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            PDFRenderPages pdfrenderpages = new PDFRenderPages();
            actors.add(pdfrenderpages);
            DisplayPanelManager displaypanelmanager = new DisplayPanelManager();
            argOption = (AbstractArgumentOption)displaypanelmanager.getOptionManager().findByProperty("width");
            displaypanelmanager.setWidth(((Integer)argOption.valueOf("1200")).intValue());
            argOption = (AbstractArgumentOption)displaypanelmanager.getOptionManager().findByProperty("height");
            displaypanelmanager.setHeight(((Integer)argOption.valueOf("600")).intValue());
            ImageViewer imageviewer = new ImageViewer();
            NullWriter nullwriter = new NullWriter();
            imageviewer.setWriter((JComponentWriter)nullwriter);
            imageviewer.setShowProperties(true);
            argOption = (AbstractArgumentOption)imageviewer.getOptionManager().findByProperty("propertiesWidth");
            imageviewer.setPropertiesWidth(((Integer)argOption.valueOf("100")).intValue());
            NullProcessor nullprocessor = new NullProcessor();
            imageviewer.setSelectionProcessor((AbstractSelectionProcessor)nullprocessor);
            NullOverlay nulloverlay = new NullOverlay();
            imageviewer.setImageOverlay((ImageOverlay)nulloverlay);
            displaypanelmanager.setPanelProvider((DisplayPanelProvider)imageviewer);
            actors.add(displaypanelmanager);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            PDFRenderPagesTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFRenderPagesTest.runTest((Test)PDFRenderPagesTest.suite());
    }
}

