/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.sink.PDFCloseDocument;
import adams.flow.source.PDFNewDocument;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProclet;
import java.io.File;

public class PDFAppendDocument
extends AbstractTransformer
implements ClassCrossReference,
StorageUser {
    private static final long serialVersionUID = 6232379845991992764L;
    protected PdfProclet[] m_Proclets;
    protected DataType m_Type;
    protected PlaceholderFile m_InputFile;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Modifies the incoming PDF document generated by " + PDFNewDocument.class.getName() + " using the PDF processors on either the specified input file or storage item.\nNeeds to be finalized with " + PDFCloseDocument.class.getName() + ".\nIf a file name is received as input, it is assumed that this is an existing PDF file and gets appended.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{PDFNewDocument.class, PDFCloseDocument.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("proclet", "proclets", (Object)new PdfProclet[0]);
        this.m_OptionManager.add("type", "type", (Object)DataType.FILE);
        this.m_OptionManager.add("input-file", "inputFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
    }

    public void setProclets(PdfProclet[] value) {
        this.m_Proclets = value;
        this.reset();
    }

    public PdfProclet[] getProclets() {
        return this.m_Proclets;
    }

    public String procletsTipText() {
        return "The processors for processing the data (file or storage item).";
    }

    public void setType(DataType value) {
        this.m_Type = value;
        this.reset();
    }

    public DataType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of data to process.";
    }

    public void setInputFile(PlaceholderFile value) {
        this.m_InputFile = value;
        this.reset();
    }

    public PlaceholderFile getInputFile() {
        return this.m_InputFile;
    }

    public String inputFileTipText() {
        return "The file to process by the PDF processors.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to retrieve.";
    }

    public boolean isUsingStorage() {
        return !this.m_Skip && this.m_Type == DataType.STORAGE;
    }

    public Class[] accepts() {
        return new Class[]{PDFGenerator.class, String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{PDFGenerator.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"inputFile", (Object)this.m_InputFile, (String)", input: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)", storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"proclets", (Object)this.m_Proclets, (String)", processors: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Object obj = null;
        switch (this.m_Type) {
            case FILE: {
                if (!this.m_InputFile.isDirectory()) break;
                result = "Input file points to a directory: " + this.m_InputFile;
                break;
            }
            case STORAGE: {
                obj = this.getStorageHandler().getStorage().get(this.m_StorageName);
                if (obj != null) break;
                result = "Storage item not available: " + this.m_StorageName;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_Type));
            }
        }
        PDFGenerator generator = null;
        PlaceholderFile file = null;
        if (result == null) {
            if (this.m_InputToken.getPayload() instanceof String) {
                file = new PlaceholderFile((String)this.m_InputToken.getPayload());
            } else if (this.m_InputToken.getPayload() instanceof File) {
                file = new PlaceholderFile((File)this.m_InputToken.getPayload());
            } else if (this.m_InputToken.getPayload() instanceof PDFGenerator) {
                generator = (PDFGenerator)this.m_InputToken.getPayload();
            } else {
                result = "Unhandled input type: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
            }
            if (file != null) {
                try {
                    generator = new PDFGenerator();
                    generator.setOutput(file);
                    generator.append();
                }
                catch (Exception e) {
                    result = this.handleException("Failed to append PDF document '" + file + "'!", e);
                }
            }
        }
        if (result == null) {
            block12: for (PdfProclet proclet : this.m_Proclets) {
                try {
                    switch (this.m_Type) {
                        case FILE: {
                            if (!proclet.canProcess(generator, (File)this.m_InputFile)) continue block12;
                            proclet.process(generator, (File)this.m_InputFile);
                            break;
                        }
                        case STORAGE: {
                            if (!proclet.canProcess(generator, obj)) continue block12;
                            proclet.process(generator, obj);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_Type));
                        }
                    }
                }
                catch (Exception e) {
                    result = this.handleException("Failed to apply processor: " + proclet.toCommandLine(), e);
                }
            }
            this.m_OutputToken = new Token(generator);
        }
        return result;
    }

    public static enum DataType {
        FILE,
        STORAGE;

    }
}

