/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.io.PdfFont;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithFilenameOutput;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import java.awt.Color;
import java.io.File;

public abstract class AbstractPdfProcletWithFilenameOutput
extends AbstractPdfProclet
implements PdfProcletWithFilenameOutput {
    private static final long serialVersionUID = -9041126884910193987L;
    protected boolean m_AddFilename;
    protected PdfFont m_FontFilename;
    protected Color m_ColorFilename;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-filename", "addFilename", (Object)false);
        this.m_OptionManager.add("font-filename", "fontFilename", (Object)new PdfFont("Helvetica", "Bold", 12.0f));
        this.m_OptionManager.add("color-filename", "colorFilename", (Object)Color.BLACK);
    }

    @Override
    public void setAddFilename(boolean value) {
        this.m_AddFilename = value;
        this.reset();
    }

    @Override
    public boolean getAddFilename() {
        return this.m_AddFilename;
    }

    @Override
    public String addFilenameTipText() {
        return "Whether to add the file name before the actual file content as separate paragraph.";
    }

    @Override
    public void setFontFilename(PdfFont value) {
        this.m_FontFilename = value;
        this.reset();
    }

    @Override
    public PdfFont getFontFilename() {
        return this.m_FontFilename;
    }

    @Override
    public String fontFilenameTipText() {
        return "The font to use for printing the file name header.";
    }

    @Override
    public void setColorFilename(Color value) {
        this.m_ColorFilename = value;
        this.reset();
    }

    @Override
    public Color getColorFilename() {
        return this.m_ColorFilename;
    }

    @Override
    public String colorFilenameTipText() {
        return "The color to use for printing the file name header.";
    }

    protected boolean addFilename(PDFGenerator generator, File file) throws Exception {
        boolean result = true;
        if (this.m_AddFilename) {
            result = this.addElement(generator, (Element)new Paragraph(file.getName() + "\n", this.m_FontFilename.toFont(this.m_ColorFilename)));
        }
        return result;
    }
}

