/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseString;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import java.awt.Color;
import java.io.File;

public class Rectangle
extends AbstractPdfProclet
implements PdfProcletWithVariableFileExtension {
    private static final long serialVersionUID = 3962046484864891107L;
    protected BaseString[] m_Extensions;
    protected float m_X;
    protected float m_Y;
    protected float m_Width;
    protected float m_Height;
    protected Color m_Color;
    protected float m_LineWidth;
    protected boolean m_Fill;

    public String globalInfo() {
        return "Draws a rectangle.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("*")});
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("width", "width", (Object)Float.valueOf(10.0f), (Number)Float.valueOf(0.001f), null);
        this.m_OptionManager.add("height", "height", (Object)Float.valueOf(10.0f), (Number)Float.valueOf(0.001f), null);
        this.m_OptionManager.add("color", "color", (Object)Color.BLACK);
        this.m_OptionManager.add("line-width", "lineWidth", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.001f), null);
        this.m_OptionManager.add("fill", "fill", (Object)false);
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    public float getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The absolute X position.";
    }

    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    public float getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The absolute Y position.";
    }

    public void setWidth(float value) {
        if (this.getOptionManager().isValid("width", (Number)Float.valueOf(value))) {
            this.m_Width = value;
            this.reset();
        }
    }

    public float getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width.";
    }

    public void setHeight(float value) {
        if (this.getOptionManager().isValid("height", (Number)Float.valueOf(value))) {
            this.m_Height = value;
            this.reset();
        }
    }

    public float getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the rectangle.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the rectangle.";
    }

    public void setLineWidth(float value) {
        if (this.getOptionManager().isValid("lineWidth", (Number)Float.valueOf(value))) {
            this.m_LineWidth = value;
            this.reset();
        }
    }

    public float getLineWidth() {
        return this.m_LineWidth;
    }

    public String lineWidthTipText() {
        return "The line width.";
    }

    public void setFill(boolean value) {
        this.m_Fill = value;
        this.reset();
    }

    public boolean getFill() {
        return this.m_Fill;
    }

    public String fillTipText() {
        return "If enabled the shape gets filled with the specified color.";
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        PdfContentByte cb = generator.getWriter().getDirectContent();
        cb.saveState();
        cb.setColorStroke(new BaseColor(this.m_Color.getRGB()));
        cb.setColorFill(new BaseColor(this.m_Color.getRGB()));
        cb.setLineWidth(this.m_LineWidth);
        cb.rectangle(this.m_X, this.m_Y, this.m_X + this.m_Width, this.m_Y + this.m_Height);
        if (this.m_Fill) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
        cb.restoreState();
        return true;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return true;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        return this.doProcess(generator, new File("."));
    }
}

