/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderFile;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class PDFBox {
    private static Logger LOGGER = LoggingHelper.getLogger(PDFBox.class);

    public static PDDocument load(String filename) {
        return PDFBox.load((File)new PlaceholderFile(filename));
    }

    public static PDDocument load(File file) {
        try {
            return PDDocument.load((File)file.getAbsoluteFile());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load PDF: " + file, (Throwable)e);
            return null;
        }
    }

    public static void close(PDDocument document) {
        if (document != null) {
            try {
                document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean save(PDDocument doc, String file) {
        return PDFBox.save(doc, (File)new PlaceholderFile(file));
    }

    public static boolean save(PDDocument doc, File file) {
        boolean result;
        try {
            doc.save(file.getAbsoluteFile());
            result = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save PDF document to file '" + file + "':", (Throwable)e);
            result = false;
        }
        return result;
    }

    public static boolean print(String filename) {
        return PDFBox.print((File)new PlaceholderFile(filename));
    }

    public static boolean print(File file) {
        boolean result = false;
        PDDocument document = PDFBox.load(file);
        if (document != null) {
            result = PDFBox.print(document);
            PDFBox.close(document);
        }
        return result;
    }

    public static boolean print(PDDocument document) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(document));
            job.print();
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to print PDF document!", (Throwable)e);
            return false;
        }
    }

    public static boolean printWithDialog(File file) {
        boolean result = false;
        PDDocument document = PDFBox.load(file);
        if (document != null) {
            result = PDFBox.printWithDialog(document);
            PDFBox.close(document);
        }
        return result;
    }

    public static boolean printWithDialog(PDDocument document) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(document));
            if (job.printDialog()) {
                job.print();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to print PDF document!", (Throwable)e);
            return false;
        }
    }
}

