/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.flow.transformer.pdfproclet.AbstractPdfProcletWithFilenameOutput;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithPageBreaks;
import java.io.File;

public abstract class AbstractPdfProcletWithPageBreaks
extends AbstractPdfProcletWithFilenameOutput
implements PdfProcletWithPageBreaks {
    private static final long serialVersionUID = -9041126884910193987L;
    protected boolean m_PageBreakBefore;
    protected boolean m_PageBreakAfter;
    protected int m_NumFilesPerPage;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("page-break-before", "pageBreakBefore", (Object)false);
        this.m_OptionManager.add("page-break-after", "pageBreakAfter", (Object)false);
        this.m_OptionManager.add("num-files", "numFilesPerPage", (Object)-1, (Number)-1, null);
    }

    @Override
    public void setPageBreakBefore(boolean value) {
        this.m_PageBreakBefore = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakBefore() {
        return this.m_PageBreakBefore;
    }

    @Override
    public String pageBreakBeforeTipText() {
        return "If true, then a page-break is added before the content of the file is inserted.";
    }

    @Override
    public void setPageBreakAfter(boolean value) {
        this.m_PageBreakAfter = value;
        this.reset();
    }

    @Override
    public boolean getPageBreakAfter() {
        return this.m_PageBreakAfter;
    }

    @Override
    public String pageBreakAfterTipText() {
        return "If true, then a page-break is added after the content of the file is inserted.";
    }

    @Override
    public void setNumFilesPerPage(int value) {
        if (this.getOptionManager().isValid("numFilesPerPage", (Number)value)) {
            this.m_NumFilesPerPage = value;
            this.reset();
        }
    }

    @Override
    public int getNumFilesPerPage() {
        return this.m_NumFilesPerPage;
    }

    @Override
    public String numFilesPerPageTipText() {
        return "The number of files to put on a page before adding an automatic page break; use -1 for unlimited.";
    }

    @Override
    protected boolean preProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = super.preProcess(generator, file);
        if (result && this.m_PageBreakBefore) {
            result = generator.newPage();
        }
        return result;
    }

    @Override
    protected boolean postProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = super.postProcess(generator, file);
        if (result && (this.m_PageBreakAfter || generator.getState().numCurrentFiles() == this.m_NumFilesPerPage)) {
            result = generator.getDocument().newPage();
            generator.getState().resetCurrentFiles();
        }
        return result;
    }

    @Override
    protected boolean preProcess(PDFGenerator generator, Object obj) throws Exception {
        boolean result = super.preProcess(generator, obj);
        if (result && this.m_PageBreakBefore) {
            result = generator.newPage();
        }
        return result;
    }

    @Override
    protected boolean postProcess(PDFGenerator generator, Object obj) throws Exception {
        boolean result = super.postProcess(generator, obj);
        if (result && (this.m_PageBreakAfter || generator.getState().numCurrentFiles() == this.m_NumFilesPerPage)) {
            result = generator.getDocument().newPage();
            generator.getState().resetCurrentFiles();
        }
        return result;
    }
}

