/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.PdfFont;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.transformer.pdfproclet.AbstractPdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithOptionalAbsolutePosition;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;

public class SpreadSheet
extends AbstractPdfProcletWithPageBreaks
implements PdfProcletWithVariableFileExtension,
PdfProcletWithOptionalAbsolutePosition {
    private static final long serialVersionUID = -5894153152920062499L;
    protected boolean m_AddComments;
    protected PdfFont m_FontComments;
    protected Color m_ColorComments;
    protected PdfFont m_FontTableHeader;
    protected Color m_ColorTableHeader;
    protected PdfFont m_FontGeneralContent;
    protected Color m_ColorGeneralContent;
    protected PdfFont m_FontNumericContent;
    protected Color m_ColorNumericContent;
    protected BaseString[] m_Extensions;
    protected int m_NumDecimals;
    protected SpreadSheetReader m_Reader;
    protected boolean m_UseAbsolutePosition;
    protected float m_X;
    protected float m_Y;

    public String globalInfo() {
        return "Adds CSV files (or any spreadsheet files that is supported) as table.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-comments", "addComments", (Object)false);
        this.m_OptionManager.add("font-comments", "fontComments", (Object)new PdfFont("Helvetica", "Italic", 12.0f));
        this.m_OptionManager.add("color-comments", "colorComments", (Object)Color.DARK_GRAY);
        this.m_OptionManager.add("font-table-header", "fontTableHeader", (Object)new PdfFont("Helvetica", "Bold", 12.0f));
        this.m_OptionManager.add("color-table-header", "colorTableHeader", (Object)Color.BLACK);
        this.m_OptionManager.add("font-general-content", "fontGeneralContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-general-content", "colorGeneralContent", (Object)Color.BLACK);
        this.m_OptionManager.add("font-numeric-content", "fontNumericContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-numeric-content", "colorNumericContent", (Object)Color.BLACK);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)1, (Number)0, null);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("csv")});
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("use-absolute-position", "useAbsolutePosition", (Object)false);
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
    }

    public void setAddComments(boolean value) {
        this.m_AddComments = value;
        this.reset();
    }

    public boolean getAddComments() {
        return this.m_AddComments;
    }

    public String addCommentsTipText() {
        return "If enabled, the spreadsheet comments (if any) get added before the table.";
    }

    public void setFontComments(PdfFont value) {
        this.m_FontComments = value;
        this.reset();
    }

    public PdfFont getFontComments() {
        return this.m_FontComments;
    }

    public String fontCommentsTipText() {
        return "The font to use for the comments.";
    }

    public void setColorComments(Color value) {
        this.m_ColorComments = value;
        this.reset();
    }

    public Color getColorComments() {
        return this.m_ColorComments;
    }

    public String colorCommentsTipText() {
        return "The color to use for the comments.";
    }

    public void setFontTableHeader(PdfFont value) {
        this.m_FontTableHeader = value;
        this.reset();
    }

    public PdfFont getFontTableHeader() {
        return this.m_FontTableHeader;
    }

    public String fontTableHeaderTipText() {
        return "The font to use for the table header.";
    }

    public void setColorTableHeader(Color value) {
        this.m_ColorTableHeader = value;
        this.reset();
    }

    public Color getColorTableHeader() {
        return this.m_ColorTableHeader;
    }

    public String colorTableHeaderTipText() {
        return "The color to use for the table header.";
    }

    public void setFontGeneralContent(PdfFont value) {
        this.m_FontGeneralContent = value;
        this.reset();
    }

    public PdfFont getFontGeneralContent() {
        return this.m_FontGeneralContent;
    }

    public String fontGeneralContentTipText() {
        return "The font to use for non-numeric content in the table.";
    }

    public void setColorGeneralContent(Color value) {
        this.m_ColorGeneralContent = value;
        this.reset();
    }

    public Color getColorGeneralContent() {
        return this.m_ColorGeneralContent;
    }

    public String colorGeneralContentTipText() {
        return "The color to use for general content.";
    }

    public void setFontNumericContent(PdfFont value) {
        this.m_FontNumericContent = value;
        this.reset();
    }

    public PdfFont getFontNumericContent() {
        return this.m_FontNumericContent;
    }

    public String fontNumericContentTipText() {
        return "The font to use for numeric content in the table.";
    }

    public void setColorNumericContent(Color value) {
        this.m_ColorNumericContent = value;
        this.reset();
    }

    public Color getColorNumericContent() {
        return this.m_ColorNumericContent;
    }

    public String colorNumericContentTipText() {
        return "The color to use for numeric content.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setNumDecimals(int value) {
        if (value >= 0) {
            this.m_NumDecimals = value;
            this.reset();
        } else {
            System.err.println("Number of decimals cannot be negative!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values in the table.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for loading the spreadsheet files.";
    }

    @Override
    public void setUseAbsolutePosition(boolean value) {
        this.m_UseAbsolutePosition = value;
        this.reset();
    }

    @Override
    public boolean getUseAbsolutePosition() {
        return this.m_UseAbsolutePosition;
    }

    @Override
    public String useAbsolutePositionTipText() {
        return "If enabled, the absolute position is used (from bottom-left corner).";
    }

    @Override
    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    @Override
    public float getX() {
        return this.m_X;
    }

    @Override
    public String XTipText() {
        return "The absolute X position.";
    }

    @Override
    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    @Override
    public float getY() {
        return this.m_Y;
    }

    @Override
    public String YTipText() {
        return "The absolute Y position.";
    }

    protected boolean doProcess(PDFGenerator generator, adams.data.spreadsheet.SpreadSheet sheet) throws Exception {
        PdfPCell pdfCell;
        Cell cell;
        boolean result;
        int i;
        String pattern = "#0";
        for (i = 0; i < this.m_NumDecimals; ++i) {
            if (i == 0) {
                pattern = pattern + ".";
            }
            pattern = pattern + "0";
        }
        DecimalFormat format = new DecimalFormat(pattern);
        boolean bl = result = sheet != null;
        if (!result) {
            return false;
        }
        Paragraph paraComments = null;
        if (this.m_AddComments) {
            paraComments = new Paragraph(Utils.flatten((List)sheet.getComments(), (String)"\n"), this.m_FontComments.toFont(this.m_ColorComments));
        }
        PdfPTable table = new PdfPTable(sheet.getColumnCount());
        HeaderRow row = sheet.getHeaderRow();
        for (String key : sheet.getHeaderRow().cellKeys()) {
            cell = row.getCell(key);
            Paragraph para = new Paragraph(cell.toString(), this.m_FontTableHeader.toFont(this.m_ColorTableHeader));
            pdfCell = new PdfPCell((Phrase)para);
            pdfCell.setHorizontalAlignment(0);
            table.addCell(pdfCell);
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            for (String key : sheet.getHeaderRow().cellKeys()) {
                cell = row.getCell(key);
                if (cell == null || cell.isMissing()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(""));
                } else if (cell.isNumeric()) {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(format.format(cell.toDouble()), this.m_FontNumericContent.toFont(this.m_ColorNumericContent)));
                    pdfCell.setHorizontalAlignment(2);
                } else {
                    pdfCell = new PdfPCell((Phrase)new Paragraph(cell.toString(), this.m_FontGeneralContent.toFont(this.m_ColorGeneralContent)));
                    pdfCell.setHorizontalAlignment(0);
                }
                table.addCell(pdfCell);
            }
        }
        if (this.m_UseAbsolutePosition) {
            ColumnText ct = this.addColumnTextAt(generator, this.m_X, this.m_Y);
            if (paraComments != null) {
                ct.addElement((Element)paraComments);
                ct.addElement((Element)new Paragraph("\n"));
            }
            ct.addElement((Element)new Paragraph("\n"));
            ct.addElement((Element)table);
            ct.go();
            generator.getState().contentAdded();
        } else {
            if (paraComments != null && (result = this.addElement(generator, (Element)paraComments))) {
                result = this.addElement(generator, (Element)new Paragraph("\n"));
            }
            if (result) {
                result = this.addElement(generator, (Element)new Paragraph("\n"));
            }
            if (result) {
                result = this.addElement(generator, (Element)table);
            }
        }
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = this.addFilename(generator, file);
        if (!result) {
            return false;
        }
        adams.data.spreadsheet.SpreadSheet sheet = this.m_Reader.read(file.getAbsolutePath());
        return sheet != null && this.doProcess(generator, sheet);
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return obj instanceof adams.data.spreadsheet.SpreadSheet || obj instanceof SpreadSheetSupporter;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        if (obj instanceof adams.data.spreadsheet.SpreadSheet) {
            return this.doProcess(generator, (adams.data.spreadsheet.SpreadSheet)obj);
        }
        if (obj instanceof SpreadSheetSupporter) {
            return this.doProcess(generator, ((SpreadSheetSupporter)obj).toSpreadSheet());
        }
        return false;
    }
}

