/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class PDFInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected Index m_PageIndex;

    public String globalInfo() {
        return "Outputs information on a PDF file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_PAGES);
        this.m_OptionManager.add("page-index", "pageIndex", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_PageIndex = new Index();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.NUM_PAGES));
        if (!types.contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pageIndex", (Object)this.m_PageIndex, (String)", page: ");
        }
        return result;
    }

    public String outputArrayTipText() {
        return "If enabled, the info items get output as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setPageIndex(Index value) {
        this.m_PageIndex = value;
        this.reset();
    }

    public Index getPageIndex() {
        return this.m_PageIndex;
    }

    public String pageIndexTipText() {
        return "The page index to use for generating page-specific information. " + this.m_PageIndex.getExample();
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case NUM_PAGES: {
                return Integer.class;
            }
            case WIDTH: 
            case HEIGHT: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue = new ArrayList();
        PlaceholderFile file = null;
        if (this.m_InputToken.getPayload() instanceof String) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload());
        } else if (this.m_InputToken.getPayload() instanceof File) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload());
        } else {
            result = "Unhandled input type: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        PdfReader reader = null;
        if (result == null) {
            try {
                reader = new PdfReader(file.getAbsolutePath());
            }
            catch (Exception e) {
                result = this.handleException("Failed to open PDF file: " + file, e);
            }
        }
        if (result == null) {
            this.m_PageIndex.setMax(reader.getNumberOfPages());
            switch (this.m_Type) {
                case NUM_PAGES: {
                    this.m_Queue.add(reader.getNumberOfPages());
                    break;
                }
                case WIDTH: {
                    this.m_Queue.add(new Double(reader.getPageSize(this.m_PageIndex.getIntIndex() + 1).getWidth()));
                    break;
                }
                case HEIGHT: {
                    this.m_Queue.add(new Double(reader.getPageSize(this.m_PageIndex.getIntIndex() + 1).getHeight()));
                    break;
                }
                default: {
                    result = "Unhandled info type: " + (Object)((Object)this.m_Type);
                }
            }
        }
        if (reader != null) {
            reader.close();
        }
        return result;
    }

    public static enum InfoType {
        NUM_PAGES,
        WIDTH,
        HEIGHT;

    }
}

