/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProclet;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.ColumnText;
import java.io.File;
import java.util.logging.Level;

public abstract class AbstractPdfProclet
extends AbstractOptionHandler
implements PdfProclet {
    private static final long serialVersionUID = -9041126884910193987L;
    public static final String MATCH_ALL_EXTENSION = "*";
    protected BaseRegExp m_RegExpFilename;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp-filename", "regExpFilename", (Object)new BaseRegExp(".*"));
    }

    @Override
    public void setRegExpFilename(BaseRegExp value) {
        this.m_RegExpFilename = value;
        this.reset();
    }

    @Override
    public BaseRegExp getRegExpFilename() {
        return this.m_RegExpFilename;
    }

    @Override
    public String regExpFilenameTipText() {
        return "The regular expression that the filename must match.";
    }

    @Override
    public abstract BaseString[] getExtensions();

    protected boolean addElement(PDFGenerator generator, Element element) throws Exception {
        boolean result = generator.getDocument().add(element);
        if (result) {
            generator.getState().contentAdded();
        }
        return result;
    }

    protected ColumnText addColumnTextAt(PDFGenerator generator, float x, float y) throws Exception {
        ColumnText result = new ColumnText(generator.getWriter().getDirectContent());
        result.setSimpleColumn(x, y, generator.getDocument().getPageSize().getWidth(), 0.0f);
        return result;
    }

    protected boolean preProcess(PDFGenerator generator, File file) throws Exception {
        return true;
    }

    protected abstract boolean doProcess(PDFGenerator var1, File var2) throws Exception;

    protected boolean postProcess(PDFGenerator generator, File file) throws Exception {
        return true;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, File file) {
        boolean result = false;
        String extension = file.getName().replaceAll(".*\\.", "");
        for (BaseString ext : this.getExtensions()) {
            if (ext.stringValue().equals(MATCH_ALL_EXTENSION)) {
                result = true;
            } else if (ext.stringValue().equalsIgnoreCase(extension)) {
                result = true;
            }
            if (result) break;
        }
        result = result && this.m_RegExpFilename.isMatch(file.getAbsolutePath());
        return result;
    }

    @Override
    public boolean process(PDFGenerator generator, File file) {
        boolean result;
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("preProcess: " + file);
            }
            if (result = this.preProcess(generator, file)) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("doProcess: " + file);
                }
                result = this.doProcess(generator, file);
            }
            if (result) {
                generator.getState().addFile();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("postProcess: " + file);
                }
                result = this.postProcess(generator, file);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to add file '" + file + "':", (Throwable)e);
        }
        return result;
    }

    @Override
    public abstract boolean canProcess(PDFGenerator var1, Object var2);

    protected boolean preProcess(PDFGenerator generator, Object obj) throws Exception {
        return true;
    }

    protected abstract boolean doProcess(PDFGenerator var1, Object var2) throws Exception;

    protected boolean postProcess(PDFGenerator generator, Object obj) throws Exception {
        return true;
    }

    @Override
    public boolean process(PDFGenerator generator, Object obj) {
        boolean result;
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("preProcess: " + obj);
            }
            if (result = this.preProcess(generator, obj)) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("doProcess: " + obj);
                }
                result = this.doProcess(generator, obj);
            }
            if (result) {
                generator.getState().addFile();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("postProcess: " + obj);
                }
                result = this.postProcess(generator, obj);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to add object '" + obj + "':", (Throwable)e);
        }
        return result;
    }
}

