/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.base.BaseString;
import adams.flow.transformer.pdfproclet.AbstractPdfProclet;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import java.awt.Color;
import java.io.File;

public class Line
extends AbstractPdfProclet
implements PdfProcletWithVariableFileExtension {
    private static final long serialVersionUID = 3962046484864891107L;
    protected BaseString[] m_Extensions;
    protected float m_X1;
    protected float m_Y1;
    protected float m_X2;
    protected float m_Y2;
    protected Color m_Color;
    protected float m_LineWidth;

    public String globalInfo() {
        return "Draws a line.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("*")});
        this.m_OptionManager.add("x1", "X1", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y1", "Y1", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("x2", "X2", (Object)Float.valueOf(10.0f), (Number)Float.valueOf(0.001f), null);
        this.m_OptionManager.add("y2", "Y2", (Object)Float.valueOf(10.0f), (Number)Float.valueOf(0.001f), null);
        this.m_OptionManager.add("color", "color", (Object)Color.BLACK);
        this.m_OptionManager.add("line-width", "lineWidth", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.001f), null);
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setX1(float value) {
        if (this.getOptionManager().isValid("X1", (Number)Float.valueOf(value))) {
            this.m_X1 = value;
            this.reset();
        }
    }

    public float getX1() {
        return this.m_X1;
    }

    public String X1TipText() {
        return "The absolute X1 position.";
    }

    public void setY1(float value) {
        if (this.getOptionManager().isValid("Y1", (Number)Float.valueOf(value))) {
            this.m_Y1 = value;
            this.reset();
        }
    }

    public float getY1() {
        return this.m_Y1;
    }

    public String Y1TipText() {
        return "The absolute Y1 position.";
    }

    public void setX2(float value) {
        if (this.getOptionManager().isValid("X2", (Number)Float.valueOf(value))) {
            this.m_X2 = value;
            this.reset();
        }
    }

    public float getX2() {
        return this.m_X2;
    }

    public String X2TipText() {
        return "The absolute X2 position.";
    }

    public void setY2(float value) {
        if (this.getOptionManager().isValid("Y2", (Number)Float.valueOf(value))) {
            this.m_Y2 = value;
            this.reset();
        }
    }

    public float getY2() {
        return this.m_Y2;
    }

    public String Y2TipText() {
        return "The absolute Y2 position.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the rectangle.";
    }

    public void setLineWidth(float value) {
        if (this.getOptionManager().isValid("lineWidth", (Number)Float.valueOf(value))) {
            this.m_LineWidth = value;
            this.reset();
        }
    }

    public float getLineWidth() {
        return this.m_LineWidth;
    }

    public String lineWidthTipText() {
        return "The line width.";
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        PdfContentByte cb = generator.getWriter().getDirectContent();
        cb.saveState();
        cb.setColorStroke(new BaseColor(this.m_Color.getRGB()));
        cb.setLineWidth(this.m_LineWidth);
        cb.moveTo(this.m_X1, this.m_Y1);
        cb.lineTo(this.m_X2, this.m_Y2);
        cb.stroke();
        cb.restoreState();
        return true;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return true;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        return this.doProcess(generator, new File("."));
    }
}

