/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.PdfFont;
import adams.core.option.parsing.PdfFontParsing;
import adams.gui.chooser.PdfFontChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PdfFontEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected PdfFontChooserPanel m_FontChooserPanel;
    protected BaseButton m_ButtonOK;
    protected BaseButton m_ButtonClose;

    public String toCustomStringRepresentation(Object obj) {
        return PdfFontParsing.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return PdfFontParsing.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        return "null";
    }

    protected JComponent createCustomEditor() {
        PdfFont currentFont = (PdfFont)this.getValue();
        this.m_FontChooserPanel = new PdfFontChooserPanel();
        this.m_FontChooserPanel.setCurrent(currentFont);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.m_FontChooserPanel), "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonOK = new BaseButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfFontEditor.this.setValue(PdfFontEditor.this.m_FontChooserPanel.getCurrent());
                PdfFontEditor.this.closeDialog(1);
            }
        });
        panelButtons.add((Component)this.m_ButtonOK);
        this.m_ButtonClose = new BaseButton("Cancel");
        this.m_ButtonClose.setMnemonic('C');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfFontEditor.this.m_FontChooserPanel.setCurrent((PdfFont)PdfFontEditor.this.getValue());
                PdfFontEditor.this.closeDialog(0);
            }
        });
        panelButtons.add((Component)this.m_ButtonClose);
        return panel;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        PdfFont currentFont = (PdfFont)this.getValue();
        if (currentFont != null) {
            this.m_FontChooserPanel.setCurrent(currentFont);
        }
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        PdfFont font = (PdfFont)this.getValue();
        String val = "No font";
        if (font != null) {
            val = font.toString();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

