/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.PDFCloseDocument;
import adams.flow.source.PDFNewDocument;
import adams.flow.transformer.PDFAppendDocument;
import adams.flow.transformer.pdfproclet.PdfProclet;
import adams.flow.transformer.pdfproclet.SpreadSheet;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFCloseDocumentTest
extends AbstractFlowTest {
    public PDFCloseDocumentTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("out.pdf");
        this.m_TestHelper.copyResourceToTmp("bolts_small.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.pdf");
        this.m_TestHelper.deleteFileFromTmp("bolts_small.csv");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(PDFCloseDocumentTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            PDFNewDocument pdfnewdocument = new PDFNewDocument();
            AbstractArgumentOption argOption = (AbstractArgumentOption)pdfnewdocument.getOptionManager().findByProperty("outputFile");
            pdfnewdocument.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/out.pdf"));
            actors.add(pdfnewdocument);
            PDFAppendDocument pdfappenddocument = new PDFAppendDocument();
            ArrayList<SpreadSheet> proclets = new ArrayList<SpreadSheet>();
            SpreadSheet spreadsheet = new SpreadSheet();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((adams.data.spreadsheet.SpreadSheet)defaultspreadsheet);
            spreadsheet.setReader((SpreadSheetReader)csvspreadsheetreader);
            proclets.add(spreadsheet);
            pdfappenddocument.setProclets(proclets.toArray(new PdfProclet[0]));
            argOption = (AbstractArgumentOption)pdfappenddocument.getOptionManager().findByProperty("inputFile");
            pdfappenddocument.setInputFile((PlaceholderFile)argOption.valueOf("${TMP}/bolts_small.csv"));
            actors.add(pdfappenddocument);
            PDFCloseDocument pdfclosedocument = new PDFCloseDocument();
            actors.add(pdfclosedocument);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            PDFCloseDocumentTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFCloseDocumentTest.runTest((Test)PDFCloseDocumentTest.suite());
    }
}

