/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.PageOrientation;
import adams.flow.core.Token;
import adams.flow.sink.PDFCloseDocument;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.transformer.PDFAppendDocument;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PageSize;

public class PDFNewDocument
extends AbstractSimpleSource
implements FileWriter,
ClassCrossReference {
    private static final long serialVersionUID = -4271476585270701409L;
    protected PageSize m_PageSize;
    protected PageOrientation m_PageOrientation;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Creates an empty PDF document.\nNeeds to be finalized with " + PDFCloseDocument.class.getName() + ".\nThe output of this source can be processed by " + PDFAppendDocument.class.getName() + ".";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{PDFAppendDocument.class, PDFCloseDocument.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-file", "outputFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("page-size", "pageSize", (Object)PageSize.A4);
        this.m_OptionManager.add("page-orientation", "pageOrientation", (Object)PageOrientation.PORTRAIT);
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The name of the PDF file to generate.";
    }

    public void setPageSize(PageSize value) {
        this.m_PageSize = value;
        this.reset();
    }

    public PageSize getPageSize() {
        return this.m_PageSize;
    }

    public String pageSizeTipText() {
        return "The page size of the generated PDF.";
    }

    public void setPageOrientation(PageOrientation value) {
        this.m_PageOrientation = value;
        this.reset();
    }

    public PageOrientation getPageOrientation() {
        return this.m_PageOrientation;
    }

    public String pageOrientationTipText() {
        return "The page orientation of the generated PDF.";
    }

    public Class[] generates() {
        return new Class[]{PDFGenerator.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)"output: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pageSize", (Object)((Object)this.m_PageSize), (String)", size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pageOrientation", (Object)this.m_PageOrientation, (String)", orientation: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_OutputFile.isDirectory()) {
            result = "Output file points to a directory: " + this.m_OutputFile;
        }
        if (result == null) {
            PDFGenerator generator = new PDFGenerator();
            generator.setLoggingLevel(this.getLoggingLevel());
            generator.setOutput(this.m_OutputFile);
            generator.setPageOrientation(this.m_PageOrientation);
            generator.setPageSize(this.m_PageSize);
            try {
                generator.open();
                this.m_OutputToken = new Token((Object)generator);
            }
            catch (Exception e) {
                result = this.handleException("Failed to create PDF document: " + this.m_OutputFile, e);
            }
        }
        return result;
    }
}

