/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Calendar;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

@MixedCopyright(author="Apache", license=License.APACHE2, note="Original class: org.apache.pdfbox.examples.pdmodel.ExtractMetadata")
public class PDFMetaData
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;

    public String globalInfo() {
        return "Actor for extracting the meta-data from a PDF.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected void addCell(Row row, String header, Calendar content) {
        row.getOwner().getHeaderRow().addCell(header).setContent(header);
        if (content != null) {
            row.addCell(header).setContent(content.getTime());
        }
    }

    protected void addCell(Row row, String header, String content) {
        row.getOwner().getHeaderRow().addCell(header).setContent(header);
        if (content != null) {
            row.addCell(header).setContent(content);
        }
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        sheet.setDataRowClass(SparseDataRow.class);
        sheet.setName("Meta-Data: " + file.getAbsolutePath());
        try {
            DataRow row = sheet.addRow();
            PDDocument document = PDDocument.load((File)file.getAbsoluteFile());
            PDDocumentInformation info = document.getDocumentInformation();
            this.addCell((Row)row, "Title", info.getTitle());
            this.addCell((Row)row, "Subject", info.getSubject());
            this.addCell((Row)row, "Author", info.getAuthor());
            this.addCell((Row)row, "Keywords", info.getKeywords());
            this.addCell((Row)row, "Producer", info.getProducer());
            this.addCell((Row)row, "Creation Date", info.getCreationDate());
            this.addCell((Row)row, "Modification Date", info.getModificationDate());
            this.addCell((Row)row, "Creator", info.getCreator());
            this.addCell((Row)row, "Trapped", info.getTrapped());
            Set keys = info.getMetadataKeys();
            for (String key : keys) {
                this.addCell((Row)row, "Meta-" + key, info.getCustomMetadataValue(key));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to extract meta-data: ", e);
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

