/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfproclet;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PdfFont;
import adams.flow.transformer.pdfproclet.AbstractPdfProcletWithPageBreaks;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PdfProcletWithOptionalAbsolutePosition;
import adams.flow.transformer.pdfproclet.PdfProcletWithVariableFileExtension;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.ColumnText;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PlainText
extends AbstractPdfProcletWithPageBreaks
implements PdfProcletWithVariableFileExtension,
PdfProcletWithOptionalAbsolutePosition {
    private static final long serialVersionUID = 3962046484864891107L;
    protected PdfFont m_FontContent;
    protected Color m_ColorContent;
    protected BaseString[] m_Extensions;
    protected boolean m_UseAbsolutePosition;
    protected float m_X;
    protected float m_Y;

    public String globalInfo() {
        return "Adds plain-text files line by line.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font-content", "fontContent", (Object)new PdfFont("Helvetica", "Normal", 12.0f));
        this.m_OptionManager.add("color-content", "colorContent", (Object)Color.BLACK);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("txt")});
        this.m_OptionManager.add("use-absolute-position", "useAbsolutePosition", (Object)false);
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
    }

    public void setFontContent(PdfFont value) {
        this.m_FontContent = value;
        this.reset();
    }

    public PdfFont getFontContent() {
        return this.m_FontContent;
    }

    public String fontContentTipText() {
        return "The font to use for the file content.";
    }

    public void setColorContent(Color value) {
        this.m_ColorContent = value;
        this.reset();
    }

    public Color getColorContent() {
        return this.m_ColorContent;
    }

    public String colorContentTipText() {
        return "The color to use for the content.";
    }

    @Override
    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    @Override
    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    @Override
    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    @Override
    public void setUseAbsolutePosition(boolean value) {
        this.m_UseAbsolutePosition = value;
        this.reset();
    }

    @Override
    public boolean getUseAbsolutePosition() {
        return this.m_UseAbsolutePosition;
    }

    @Override
    public String useAbsolutePositionTipText() {
        return "If enabled, the absolute position is used (from bottom-left corner).";
    }

    @Override
    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    @Override
    public float getX() {
        return this.m_X;
    }

    @Override
    public String XTipText() {
        return "The absolute X position.";
    }

    @Override
    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    @Override
    public float getY() {
        return this.m_Y;
    }

    @Override
    public String YTipText() {
        return "The absolute Y position.";
    }

    protected boolean doProcess(PDFGenerator generator, List<String> paragraphs) throws Exception {
        boolean result = true;
        if (this.m_UseAbsolutePosition) {
            ColumnText ct = this.addColumnTextAt(generator, this.m_X, this.m_Y);
            ct.addElement((Element)new Paragraph(Utils.flatten(paragraphs, (String)"\n"), this.m_FontContent.toFont(this.m_ColorContent)));
            ct.go();
            generator.getState().contentAdded();
        } else {
            result = this.addElement(generator, (Element)new Paragraph(Utils.flatten(paragraphs, (String)"\n"), this.m_FontContent.toFont(this.m_ColorContent)));
        }
        return result;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, File file) throws Exception {
        boolean result = this.addFilename(generator, file);
        if (result) {
            List paragraphs = FileUtils.loadFromFile((File)file);
            result = this.doProcess(generator, paragraphs);
        }
        return result;
    }

    @Override
    public boolean canProcess(PDFGenerator generator, Object obj) {
        return true;
    }

    @Override
    protected boolean doProcess(PDFGenerator generator, Object obj) throws Exception {
        ArrayList<String> paragraphs = new ArrayList<String>(Arrays.asList(obj.toString().split("\n")));
        return this.doProcess(generator, paragraphs);
    }
}

