/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * PageSize.java
 * Copyright (C) 2016 University of Waikato, Hamilton, NZ
 */

package adams.flow.transformer.pdfproclet;

/**
 * Enumeration of all possible page sizes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 13474 $
 */
public enum PageSize {
  A0,
  A1,
  A10,
  A2,
  A3,
  A4,
  A5,
  A6,
  A7,
  A8,
  A9,
  ARCH_A,
  ARCH_B,
  ARCH_C,
  ARCH_D,
  ARCH_E,
  B0,
  B1,
  B10,
  B2,
  B3,
  B4,
  B5,
  B6,
  B7,
  B8,
  B9,
  CROWN_OCTAVO,
  CROWN_QUARTO,
  DEMY_OCTAVO,
  DEMY_QUARTO,
  EXECUTIVE,
  FLSA,
  FLSE,
  HALFLETTER,
  ID_1,
  ID_2,
  ID_3,
  LARGE_CROWN_OCTAVO,
  LARGE_CROWN_QUARTO,
  LEDGER,
  LEGAL,
  LETTER,
  NOTE,
  PENGUIN_LARGE_PAPERBACK,
  PENGUIN_SMALL_PAPERBACK,
  POSTCARD,
  ROYAL_OCTAVO,
  ROYAL_QUARTO,
  SMALL_PAPERBACK,
  TABLOID
}
