/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pdfgenerate;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.PageOrientation;
import adams.flow.core.Token;
import adams.flow.transformer.PDFCreate;
import adams.flow.transformer.pdfgenerate.AbstractPDFGenerator;
import adams.flow.transformer.pdfproclet.Image;
import adams.flow.transformer.pdfproclet.PageSize;
import adams.flow.transformer.pdfproclet.PdfProclet;
import adams.flow.transformer.pdfproclet.PlainText;
import adams.flow.transformer.pdfproclet.SpreadSheet;
import java.io.File;

public class Proclets
extends AbstractPDFGenerator {
    private static final long serialVersionUID = -5180261720095154102L;
    protected PageSize m_PageSize;
    protected PageOrientation m_PageOrientation;
    protected PdfProclet[] m_Proclets;

    public String globalInfo() {
        return "Processes an array of files using the specified PDF proclets.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("page-size", "pageSize", (Object)PageSize.A4);
        this.m_OptionManager.add("page-orientation", "pageOrientation", (Object)PageOrientation.PORTRAIT);
        this.m_OptionManager.add("proclet", "proclets", (Object)new PdfProclet[]{new PlainText(), new SpreadSheet(), new Image()});
    }

    public String outputFileTipText() {
        return "The PDF file to generate.";
    }

    public void setPageSize(PageSize value) {
        this.m_PageSize = value;
        this.reset();
    }

    public PageSize getPageSize() {
        return this.m_PageSize;
    }

    public String pageSizeTipText() {
        return "The page size of the generated PDF.";
    }

    public void setPageOrientation(PageOrientation value) {
        this.m_PageOrientation = value;
        this.reset();
    }

    public PageOrientation getPageOrientation() {
        return this.m_PageOrientation;
    }

    public String pageOrientationTipText() {
        return "The page orientation of the generated PDF.";
    }

    public void setProclets(PdfProclet[] value) {
        this.m_Proclets = value;
        this.reset();
    }

    public PdfProclet[] getProclets() {
        return this.m_Proclets;
    }

    public String procletsTipText() {
        return "The processors for processing the files.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"pageSize", (Object)((Object)this.m_PageSize), (String)"size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pageOrientation", (Object)this.m_PageOrientation, (String)", orientation: ");
        return result;
    }

    @Override
    protected String check(Object[] objects) {
        String result = super.check(objects);
        if (result == null) {
            if (objects == null || objects.length == 0) {
                result = "No objects provided!";
            }
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof String || objects[i] instanceof File) continue;
                result = "Object #" + (i + 1) + " is neither a string or a file object: " + Utils.classToString((Object)objects[i]);
                break;
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    @Override
    protected String doProcess(Object[] objects, File outputFile) {
        String result;
        PDFCreate create = new PDFCreate();
        create.setLoggingLevel(this.getLoggingLevel());
        create.setOutputFile(new PlaceholderFile(outputFile));
        create.setPageOrientation(this.getPageOrientation());
        create.setPageSize(this.getPageSize());
        create.setProclets((PdfProclet[])ObjectCopyHelper.copyObjects((Object[])this.m_Proclets));
        try {
            result = create.setUp();
            if (result == null) {
                create.input(new Token((Object)objects));
                result = create.execute();
            }
            create.cleanUp();
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to generate PDF: " + outputFile), (Throwable)e);
        }
        return result;
    }
}

