/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.multiobjectexport;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PdfFont;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.data.PageOrientation;
import adams.flow.transformer.pdfproclet.Image;
import adams.flow.transformer.pdfproclet.PDFGenerator;
import adams.flow.transformer.pdfproclet.PageSize;
import adams.flow.transformer.pdfproclet.PdfProclet;
import adams.flow.transformer.pdfproclet.PlainText;
import adams.flow.transformer.pdfproclet.SpreadSheet;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.multiobjectexport.AbstractMultiObjectExportWithPreferredExtensions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PDFExport
extends AbstractMultiObjectExportWithPreferredExtensions
implements FileWriter {
    private static final long serialVersionUID = 360117990418986281L;
    protected PlaceholderFile m_OutputFile;
    protected PageSize m_PageSize;
    protected PageOrientation m_PageOrientation;
    protected PdfProclet[] m_Proclets;

    public String globalInfo() {
        return "Generates a PDF from the exported objects (first get turned into files).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("page-size", "pageSize", (Object)PageSize.A4);
        this.m_OptionManager.add("page-orientation", "pageOrientation", (Object)PageOrientation.PORTRAIT);
        this.m_OptionManager.add("proclet", "proclets", (Object)this.getDefaultProclets());
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The PDF file to generate.";
    }

    public void setPageSize(PageSize value) {
        this.m_PageSize = value;
        this.reset();
    }

    public PageSize getPageSize() {
        return this.m_PageSize;
    }

    public String pageSizeTipText() {
        return "The page size of the generated PDF.";
    }

    public void setPageOrientation(PageOrientation value) {
        this.m_PageOrientation = value;
        this.reset();
    }

    public PageOrientation getPageOrientation() {
        return this.m_PageOrientation;
    }

    public String pageOrientationTipText() {
        return "The page orientation of the generated PDF.";
    }

    protected PdfProclet[] getDefaultProclets() {
        PlainText plain = new PlainText();
        plain.setAddFilename(true);
        plain.setPageBreakAfter(true);
        plain.setFontContent(new PdfFont("Courier-Normal-12"));
        SpreadSheet sheet = new SpreadSheet();
        sheet.setAddFilename(true);
        sheet.setPageBreakAfter(true);
        Image image = new Image();
        image.setAddFilename(true);
        image.setPageBreakAfter(true);
        image.setScale(0.75);
        return new PdfProclet[]{plain, sheet, image};
    }

    public void setProclets(PdfProclet[] value) {
        this.m_Proclets = value;
        this.reset();
    }

    public PdfProclet[] getProclets() {
        return this.m_Proclets;
    }

    public String procletsTipText() {
        return "The processors for processing the files.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExport(String[] names, Object[] objects) {
        int i;
        for (i = 0; i < names.length; ++i) {
            names[i] = FileUtils.createFilename((String)names[i], (String)"");
        }
        names = this.disambiguateNames(names);
        MessageCollection errors = new MessageCollection();
        File outputDir = TempUtils.createTempFile((String)"zipexport", (String)"");
        if (!outputDir.mkdirs()) {
            errors.add("Failed to create temporary output directory: " + outputDir);
        }
        ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
        if (errors.isEmpty()) {
            for (i = 0; i < names.length; ++i) {
                List exporters = this.determineExporters(names[i], objects[i], errors);
                for (AbstractObjectExporter abstractObjectExporter : exporters) {
                    String ext = this.determineExtension(abstractObjectExporter);
                    PlaceholderFile file = new PlaceholderFile(outputDir.getAbsolutePath() + File.separator + names[i] + "." + ext);
                    String msg = abstractObjectExporter.export(objects[i], (File)file);
                    if (msg != null) {
                        errors.add("Failed to find export '" + names[i] + "'/" + Utils.classToString((Object)objects[i]) + "\n" + msg);
                        continue;
                    }
                    files.add(file);
                }
            }
        }
        if (errors.isEmpty()) {
            PDFGenerator generator = new PDFGenerator();
            generator.setLoggingLevel(this.getLoggingLevel());
            generator.setOutput(this.getOutputFile());
            generator.setPageSize(this.getPageSize());
            generator.setPageOrientation(this.getPageOrientation());
            generator.setProclets(this.getProclets());
            try {
                generator.open();
                for (File file : files) {
                    try {
                        generator.addFile(file);
                    }
                    catch (Exception e) {
                        errors.add("Problems adding file '" + file + "'!", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                errors.add("Failed to create PDF: " + this.m_OutputFile, (Throwable)e);
            }
            finally {
                generator.close();
            }
        }
        if (outputDir.exists()) {
            FileUtils.delete((File)outputDir);
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toString();
    }
}

