/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.PDFExtract;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PDFExtractTest
extends AbstractFlowTest {
    public PDFExtractTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("multiple_pages.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("multiple_pages.pdf");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("multiple_pages.pdf")});
        PDFExtract pdf = new PDFExtract();
        pdf.setPages(new Range("1,4-last"));
        pdf.setOutput((PlaceholderFile)new TmpFile("dumpfile.pdf"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sfs, pdf});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(PDFExtractTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PDFExtractTest.runTest((Test)PDFExtractTest.suite());
    }
}

