/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.gui.core.ImageManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFBox {
    private static Logger LOGGER = LoggingHelper.getLogger(PDFBox.class);

    public static PDDocument load(String filename) {
        return PDFBox.load((File)new PlaceholderFile(filename));
    }

    public static PDDocument load(File file) {
        try {
            return PDDocument.load((File)file.getAbsoluteFile());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load PDF: " + file, (Throwable)e);
            return null;
        }
    }

    public static void close(PDDocument document) {
        if (document != null) {
            try {
                document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean save(PDDocument doc, String file) {
        return PDFBox.save(doc, (File)new PlaceholderFile(file));
    }

    public static boolean save(PDDocument doc, File file) {
        boolean result;
        try {
            doc.save(file.getAbsoluteFile());
            result = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save PDF document to file '" + file + "':", (Throwable)e);
            result = false;
        }
        return result;
    }

    public static boolean print(String filename) {
        return PDFBox.print((File)new PlaceholderFile(filename));
    }

    public static boolean print(File file) {
        boolean result = false;
        PDDocument document = PDFBox.load(file);
        if (document != null) {
            result = PDFBox.print(document);
            PDFBox.close(document);
        }
        return result;
    }

    public static boolean print(PDDocument document) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(document));
            job.print();
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to print PDF document!", (Throwable)e);
            return false;
        }
    }

    public static boolean printWithDialog(File file) {
        boolean result = false;
        PDDocument document = PDFBox.load(file);
        if (document != null) {
            result = PDFBox.printWithDialog(document);
            PDFBox.close(document);
        }
        return result;
    }

    public static boolean printWithDialog(PDDocument document) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(document));
            if (job.printDialog()) {
                job.print();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to print PDF document!", (Throwable)e);
            return false;
        }
    }

    public static int getPageCount(File file) {
        int result;
        try {
            PDDocument doc = PDDocument.load((File)file.getAbsoluteFile());
            result = doc.getNumberOfPages();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to determine page count of: " + file, (Throwable)e);
            result = -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractText(File file) {
        String result;
        PDDocument doc = null;
        try {
            doc = PDDocument.load((File)file.getAbsoluteFile());
            PDFTextStripper stripper = new PDFTextStripper();
            result = stripper.getText(doc);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to extract text from: " + file, (Throwable)e);
            result = null;
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    @MixedCopyright(author="https://stackoverflow.com/users/156669/matt", url="https://stackoverflow.com/a/37664125/4698227", license=License.CC_BY_SA_3)
    public static List<RenderedImage> extractImagesFromResources(PDResources resources) throws IOException {
        ArrayList<RenderedImage> result = new ArrayList<RenderedImage>();
        if (resources == null) {
            return result;
        }
        for (COSName xObjectName : resources.getXObjectNames()) {
            PDXObject xObject = resources.getXObject(xObjectName);
            if (xObject instanceof PDFormXObject) {
                result.addAll(PDFBox.extractImagesFromResources(((PDFormXObject)xObject).getResources()));
                continue;
            }
            if (!(xObject instanceof PDImageXObject)) continue;
            result.add(((PDImageXObject)xObject).getImage());
        }
        return result;
    }

    @MixedCopyright(author="https://stackoverflow.com/users/156669/matt", url="https://stackoverflow.com/a/37664125/4698227", license=License.CC_BY_SA_3)
    public static List<BufferedImage> extractImages(PDDocument document) throws IOException {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        for (PDPage page : document.getPages()) {
            for (RenderedImage image : PDFBox.extractImagesFromResources(page.getResources())) {
                if (images.contains(image)) continue;
                images.add(image);
            }
        }
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        for (RenderedImage image : images) {
            result.add(ImageManager.toBufferedImage((RenderedImage)image));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BufferedImage> extractImages(File file) throws IOException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load((File)file.getAbsoluteFile());
            List<BufferedImage> list = PDFBox.extractImages(doc);
            return list;
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

