/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.UnorderedRange;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.management.User;
import adams.env.Environment;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class iTextPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractPages(LoggingSupporter logging, File input, UnorderedRange range, File output) {
        Object result = null;
        FileOutputStream fos = null;
        try {
            if (logging != null && logging.isLoggingEnabled()) {
                logging.getLogger().info("Extracting pages from '" + input + "' into '" + output + "'");
            }
            Document document = new Document();
            fos = new FileOutputStream(output.getAbsolutePath());
            PdfCopy copy = new PdfCopy(document, (OutputStream)fos);
            document.open();
            document.addCreationDate();
            document.addCreator(Environment.getInstance().getProject());
            document.addAuthor(User.getName());
            PdfReader reader = new PdfReader(input.getAbsolutePath());
            if (logging != null && logging.isLoggingEnabled()) {
                logging.getLogger().info("- #pages: " + reader.getNumberOfPages());
            }
            range.setMax(reader.getNumberOfPages());
            int[] pages = range.getIntIndices();
            for (int i = 0; i < pages.length; ++i) {
                int page = pages[i] + 1;
                copy.addPage(copy.getImportedPage(reader, page));
                if (logging == null || !logging.isLoggingEnabled()) continue;
                logging.getLogger().info("- adding page: " + page);
            }
            copy.freeReader(reader);
            document.close();
        }
        catch (Exception e) {
            try {
                result = logging != null ? LoggingHelper.handleException((LoggingSupporter)logging, (String)("Failed to extract pages from " + input + " to " + output + ": "), (Throwable)e) : "Failed to extract pages from " + input + " to " + output + ":\n" + LoggingHelper.throwableToString((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

