/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.pdf.PDFPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.icepdf.core.pobjects.Document;

public class PDFViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 1523870513962160664L;
    protected PDFPanel m_PDFPanel;
    protected double m_Zoom;
    protected transient BaseFileChooser m_PDFFileChooser;

    public String globalInfo() {
        return "Actor for displaying PDF files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0);
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setZoom(double value) {
        this.m_Zoom = value;
        this.reset();
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        if (this.m_PDFPanel != null) {
            this.m_PDFPanel.closeDocument();
        }
    }

    protected BasePanel newPanel() {
        this.m_PDFPanel = new PDFPanel();
        return this.m_PDFPanel;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected BaseFileChooser getPDFFileChooser() {
        if (this.m_PDFFileChooser == null) {
            BaseFileChooser fileChooser = new BaseFileChooser();
            ExtensionFileFilter filter = ExtensionFileFilter.getPdfFileFilter();
            fileChooser.addChoosableFileFilter((FileFilter)filter);
            fileChooser.setFileFilter((FileFilter)filter);
            fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            this.m_PDFFileChooser = fileChooser;
        }
        return this.m_PDFFileChooser;
    }

    protected void saveAs() {
        int retVal = this.getPDFFileChooser().showSaveDialog((Component)this.m_Panel);
        if (retVal != 0) {
            return;
        }
        String msg = this.m_PDFPanel.saveTo(this.getPDFFileChooser().getSelectedFile());
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)this.getParentComponent(), (String)("Failed to save PDF document to: " + this.getPDFFileChooser().getSelectedFile() + "\n" + msg));
        }
    }

    protected void display(Token token) {
        this.clearPanel();
        if (token.getPayload() instanceof String) {
            this.m_PDFPanel.setDocument((String)token.getPayload(String.class));
        } else if (token.getPayload() instanceof File) {
            this.m_PDFPanel.setDocument((File)token.getPayload(File.class));
        }
        this.m_PDFPanel.setScale(this.m_Zoom / 100.0);
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_PDFPanel != null) {
            this.m_PDFPanel.cleanUp();
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected PDFPanel m_PDFPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_PDFPanel = new PDFPanel();
                this.add((Component)((Object)this.m_PDFPanel), "Center");
            }

            public void display(Token token) {
                if (token.getPayload() instanceof String) {
                    this.m_PDFPanel.setDocument((String)token.getPayload(String.class));
                } else if (token.getPayload() instanceof File) {
                    this.m_PDFPanel.setDocument((File)token.getPayload(File.class));
                }
                this.m_PDFPanel.setScale(PDFViewer.this.m_Zoom / 100.0);
            }

            public void cleanUp() {
                this.m_PDFPanel.cleanUp();
            }

            public void clearPanel() {
                this.m_PDFPanel.closeDocument();
            }

            public JComponent supplyComponent() {
                return this.m_PDFPanel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, Document.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls) || SendToActionUtils.isAvailable(Document.class, (Class[])cls)) && this.m_PDFPanel.getDocument() != null;
    }

    public Object getSendToItem(Class[] cls) {
        PlaceholderFile result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            String msg;
            if (this.m_PDFPanel.getDocument() != null && (msg = this.m_PDFPanel.saveTo((File)(result = SendToActionUtils.nextTmpFile((String)"pdfviewer", (String)"pdf")))) != null) {
                this.getLogger().severe("Failed to save PDF to '" + result + "'!\n" + msg);
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(Document.class, (Class[])cls)) {
            result = this.m_PDFPanel.getDocument();
        }
        return result;
    }
}

