/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.UnorderedRange;
import adams.core.io.PlaceholderFile;
import adams.core.io.iTextPDF;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PDFExtract
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected PlaceholderFile m_Output;
    protected UnorderedRange m_Pages;

    public String globalInfo() {
        return "Actor for extracting a range of pages from a PDF file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("pages", "pages", (Object)new UnorderedRange("first-last"));
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The PDF file to output the extracted pages to.";
    }

    public void setPages(UnorderedRange value) {
        this.m_Pages = value;
        this.reset();
    }

    public UnorderedRange getPages() {
        return this.m_Pages;
    }

    public String pagesTipText() {
        return "The range of pages to extract; " + this.m_Pages.getExample();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"pages", (Object)this.m_Pages);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)this.m_Output, (String)" -> ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        String result = iTextPDF.extractPages((LoggingSupporter)this, file, this.m_Pages, (File)this.m_Output);
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        }
        return result;
    }
}

