/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.UnorderedRange;
import adams.core.io.FileUtils;
import adams.core.io.PDFBox;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.io.iTextPDF;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PDFExtractText
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected PlaceholderFile m_Output;
    protected UnorderedRange m_Pages;

    public String globalInfo() {
        return "Actor for extracting the text of a range of pages from a PDF file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pages", "pages", (Object)new UnorderedRange("first-last"));
    }

    public void setPages(UnorderedRange value) {
        this.m_Pages = value;
        this.reset();
    }

    public UnorderedRange getPages() {
        return this.m_Pages;
    }

    public String pagesTipText() {
        return "The range of pages to extract; " + this.m_Pages.getExample();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"pages", (Object)this.m_Pages);
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        Object result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Extracting text from '" + file + "'");
        }
        String content = null;
        if (!this.m_Pages.isAllRange()) {
            File tmpFile = TempUtils.createTempFile((String)"pdfextracttext-", (String)".pdf");
            result = iTextPDF.extractPages((LoggingSupporter)this, file, this.m_Pages, tmpFile);
            if (result == null) {
                content = PDFBox.extractText(tmpFile);
            }
            FileUtils.delete((File)tmpFile);
        } else {
            content = PDFBox.extractText(file);
        }
        if (content == null) {
            result = "Failed to extract text from '" + file + "'!";
        } else {
            this.m_OutputToken = new Token((Object)content);
        }
        return result;
    }
}

