/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.pdfgenerate.AbstractPDFGenerator;
import adams.flow.transformer.pdfgenerate.Proclets;
import java.io.File;

public class PDFGenerate
extends AbstractTransformer
implements FileWriter {
    private static final long serialVersionUID = 5783362940767103716L;
    protected PlaceholderFile m_OutputFile;
    protected AbstractPDFGenerator m_Generator;

    public String globalInfo() {
        return "Actor for generating PDF files using the provided PDF generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("generator", "generator", (Object)new Proclets());
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The PDF file to generate.";
    }

    public void setGenerator(AbstractPDFGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractPDFGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The page size of the generated PDF.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)"output: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)", generator: ");
        return result;
    }

    public Class[] accepts() {
        return this.m_Generator.accepts();
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        Object[] files = FileUtils.toPlaceholderFileArray((Object)this.m_InputToken.getPayload());
        String result = this.m_Generator.process(files, (File)this.m_OutputFile);
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_OutputFile.getAbsolutePath());
        }
        return result;
    }
}

