/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

@MixedCopyright(author="Apache", license=License.APACHE2, note="Original class: org.apache.pdfbox.examples.pdmodel.ExtractMetadata")
public class PDFMetaData
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected OutputType m_OutputType;

    public String globalInfo() {
        return "Actor for extracting the meta-data from a PDF.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.SPREADSHEET);
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "How to output the meta-data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputType", (Object)((Object)this.m_OutputType), (String)"output: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        switch (this.m_OutputType) {
            case SPREADSHEET: {
                return new Class[]{SpreadSheet.class};
            }
            case MAP: {
                return new Class[]{Map.class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + this.m_OutputType);
    }

    protected void addCell(Row row, String header, Calendar content) {
        row.getOwner().getHeaderRow().addCell(header).setContent(header);
        if (content != null) {
            row.addCell(header).setContent(content.getTime());
        }
    }

    protected void addCell(Row row, String header, String content) {
        row.getOwner().getHeaderRow().addCell(header).setContent(header);
        if (content != null) {
            row.addCell(header).setContent(content);
        }
    }

    public void addMapValue(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            if (value instanceof Calendar) {
                map.put(key, ((Calendar)value).getTime());
            } else {
                map.put(key, value);
            }
        }
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        try {
            PDDocument document = PDDocument.load((File)file.getAbsoluteFile());
            PDDocumentInformation info = document.getDocumentInformation();
            Set keys = info.getMetadataKeys();
            switch (this.m_OutputType) {
                case SPREADSHEET: {
                    DefaultSpreadSheet sheet = new DefaultSpreadSheet();
                    sheet.setDataRowClass(SparseDataRow.class);
                    sheet.setName("Meta-Data: " + file.getAbsolutePath());
                    DataRow row = sheet.addRow();
                    this.addCell((Row)row, "Title", info.getTitle());
                    this.addCell((Row)row, "Subject", info.getSubject());
                    this.addCell((Row)row, "Author", info.getAuthor());
                    this.addCell((Row)row, "Keywords", info.getKeywords());
                    this.addCell((Row)row, "Producer", info.getProducer());
                    this.addCell((Row)row, "Creation Date", info.getCreationDate());
                    this.addCell((Row)row, "Modification Date", info.getModificationDate());
                    this.addCell((Row)row, "Creator", info.getCreator());
                    this.addCell((Row)row, "Trapped", info.getTrapped());
                    for (String key : keys) {
                        this.addCell((Row)row, "Meta-" + key, info.getCustomMetadataValue(key));
                    }
                    this.m_OutputToken = new Token((Object)sheet);
                    break;
                }
                case MAP: {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    this.addMapValue(map, "Title", info.getTitle());
                    this.addMapValue(map, "Subject", info.getSubject());
                    this.addMapValue(map, "Author", info.getAuthor());
                    this.addMapValue(map, "Keywords", info.getKeywords());
                    this.addMapValue(map, "Producer", info.getProducer());
                    this.addMapValue(map, "Creation Date", info.getCreationDate());
                    this.addMapValue(map, "Modification Date", info.getModificationDate());
                    this.addMapValue(map, "Creator", info.getCreator());
                    this.addMapValue(map, "Trapped", info.getTrapped());
                    for (String key : keys) {
                        this.addMapValue(map, "Meta-" + key, info.getCustomMetadataValue(key));
                    }
                    this.m_OutputToken = new Token(map);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + this.m_OutputType);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to extract meta-data: ", e);
        }
        return result;
    }

    public static enum OutputType {
        SPREADSHEET,
        MAP;

    }
}

